/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.xml;

import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.xml.XmlParser;
import com.sonyericsson.youtube.model.YouTubeContent;
import org.xml.sax.Attributes;

public class GetVideoInfoParser
extends XmlParser {
    protected YouTubeContent currentContent = null;
    private static final String ENTRY_PATH = "/entry";
    private String access = null;
    private String category = null;
    private String description = null;
    private String geoRss = null;
    private String keywords = null;
    private String location = null;
    private String name = "";
    private String noEmbed = null;
    private String reasonCode = "";
    private String title = null;

    public void startElement(String element, Attributes attributes) {
        super.startElement(element, attributes);
        if (this.isCurrentPath(ENTRY_PATH)) {
            this.currentContent = new YouTubeContent();
        }
        if (this.isCurrentPath("yt:state")) {
            this.name = attributes.getValue("name");
            this.reasonCode = attributes.getValue("reasonCode");
            Log.trace("GetVideoInfoParser - name: " + this.name);
            Log.trace("GetVideoInfoParser - reasonCode: " + this.reasonCode);
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.isCurrentPath("/entry/media:group/media:category")) {
            this.category = new String(ch, start, length);
            this.currentContent.setCategory(this.category);
            Log.trace("GetVideoInfoParser - category: " + this.category);
        } else if (this.isCurrentPath("/entry/media:group/media:description")) {
            this.description = new String(ch, start, length);
            if (this.description == null || this.description.trim().length() <= 0) {
                this.description = "Description";
            }
            this.currentContent.setDescription(this.description);
            Log.trace("GetVideoInfoParser - description: " + this.description);
        } else if (this.isCurrentPath("/entry/media:group/media:keywords")) {
            this.keywords = new String(ch, start, length);
            this.currentContent.setKeywords(this.keywords);
            Log.trace("GetVideoInfoParser - keywords: " + this.keywords);
        } else if (this.isCurrentPath("/entry/yt:location")) {
            this.location = new String(ch, start, length);
            this.currentContent.setLocation(this.location);
            Log.trace("GetVideoInfoParser - location: " + this.location);
        } else if (this.isCurrentPath("/entry/media:group/media:title")) {
            this.title = new String(ch, start, length);
            if (this.title == null || this.title.trim().length() <= 0) {
                this.title = "Title";
            }
            this.currentContent.setTitle(this.title);
            Log.trace("GetVideoInfoParser - title: " + this.title);
        }
    }

    public final void endElement(String element) {
        if (element.equalsIgnoreCase("yt:private")) {
            this.access = "private";
            this.currentContent.setAccess(this.access);
            Log.trace("GetVideoInfoParser - access: " + this.access);
        }
        if (element.equalsIgnoreCase("yt:noembed")) {
            this.noEmbed = "yt:noembed";
            this.currentContent.setNoEmbed(this.noEmbed);
        }
        if (element.equalsIgnoreCase("georss:where")) {
            this.geoRss = "georss:where";
            this.currentContent.setGeoRss(this.geoRss);
        }
    }

    public String getAccess() {
        return this.access;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGeoRss() {
        return this.geoRss;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNoEmbed() {
        return this.noEmbed;
    }

    public String getTitle() {
        return this.title;
    }

    public YouTubeContent getContent() {
        return this.currentContent;
    }

    public String getName() {
        return this.name;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }
}

