/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.service.xml;

import com.sonyericsson.webalbum.model.EntryList;
import com.sonyericsson.webalbum.xml.XmlParser;
import com.sonyericsson.youtube.model.YouTubeContent;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import org.xml.sax.Attributes;

public class ListVideoParser
extends XmlParser {
    private String nextUrl = "";
    private YouTubeContent video;
    private int numberOfVideos;
    private boolean hasNext = false;
    private Vector videosVector = new Vector();
    private static final String ENTRY_FEED_PATH = "/feed/entry";
    private static final String ENTRY_PATH = "entry";
    private static final String ENTRY_FEED = "/feed";

    public void startElement(String element, Attributes attributes) {
        String tempUrl;
        super.startElement(element, attributes);
        if (this.isCurrentPath(ENTRY_FEED_PATH)) {
            this.video = new YouTubeContent();
        }
        if (this.video != null && this.isCurrentPath("/feed/entry/link") && (tempUrl = attributes.getValue("rel")).indexOf("#mobile") != -1) {
            this.video.setVideoUrl(attributes.getValue("href"));
        }
        if (this.isCurrentPath("/feed/link") && (tempUrl = attributes.getValue("rel")).equals("next")) {
            this.setNextUrl(attributes.getValue("href"));
            this.hasNext = true;
        }
        if (this.video != null && this.isCurrentPath("/feed/entry/media:group/media:thumbnail")) {
            this.video.setVideoThumbnail(attributes.getValue("url"));
        }
    }

    public void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.isCurrentPath("/feed/entry/media:group/media:description")) {
            this.video.setDescription(new String(ch, start, length));
        }
        if (this.isCurrentPath("/feed/entry/media:group/media:category")) {
            this.video.setCategory(new String(ch, start, length));
        }
        if (this.isCurrentPath("/feed/entry/media:group/media:title")) {
            this.video.setTitle(new String(ch, start, length));
        }
        if (this.isCurrentPath("/feed/entry/media:group/media:keywords")) {
            this.video.setKeywords(new String(ch, start, length));
        }
        if (this.isCurrentPath("/feed/entry/id")) {
            String tempStringValue = new String(ch, start, length);
            int tempStartIndex = tempStringValue.lastIndexOf(47) + 1;
            this.video.setId(tempStringValue.substring(tempStartIndex));
        }
        if (this.isCurrentPath("/feed/entry/published")) {
            String isoTime = new String(ch, start, length);
            this.video.setTimestamp(this.decodeTimestamp(isoTime));
        }
    }

    public final void endElement(String element) {
        if (this.video != null) {
            if (element.equals("yt:private")) {
                this.video.setAccess("private");
            }
            if (element.equals(ENTRY_PATH)) {
                this.videosVector.addElement(this.video);
                ++this.numberOfVideos;
                this.video = null;
            }
        }
    }

    public EntryList getEntries() {
        return new EntryList(this.numberOfVideos, 0, this.videosVector);
    }

    public String getNextUrl() {
        return this.nextUrl;
    }

    public void setNextUrl(String nextUrl) {
        this.nextUrl = nextUrl;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    public Vector getVideosVector() {
        return this.videosVector;
    }

    public int getNumberOfVideos() {
        return this.numberOfVideos;
    }

    private long decodeTimestamp(String isoTime) {
        long timestamp = 0L;
        try {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar.set(1, Integer.parseInt(isoTime.substring(0, 4)));
            calendar.set(2, Integer.parseInt(isoTime.substring(5, 7)) - 1);
            calendar.set(5, Integer.parseInt(isoTime.substring(8, 10)));
            calendar.set(11, Integer.parseInt(isoTime.substring(11, 13)));
            calendar.set(12, Integer.parseInt(isoTime.substring(14, 16)));
            calendar.set(13, Integer.parseInt(isoTime.substring(17, 19)));
            calendar.set(14, 0);
            timestamp = calendar.getTime().getTime();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return timestamp / 1000L;
    }
}

