/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.youtube.utils;

import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.ServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RMSStorage {
    private RecordStore rs_YoutubeUser;
    static final String REC_STORE = "UserInfo";
    private static final int RECORD_ID = 1;
    private static final int TOKEN_FIELD = 0;
    private static final int NAME_FIELD = 1;
    private static final int LOGIN_FIELD = 2;
    private static final int PASSWORD_FIELD = 3;
    private static RMSStorage rmsAuthInstance;

    private RMSStorage() throws ServiceException {
        this.open();
    }

    public static RMSStorage getRMSStorage() throws ServiceException {
        if (rmsAuthInstance == null) {
            rmsAuthInstance = new RMSStorage();
        }
        return rmsAuthInstance;
    }

    private void open() throws ServiceException {
        try {
            this.rs_YoutubeUser = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
        }
        catch (RecordStoreException rse) {
            Log.error("RecordStoreException opening Record Store: " + rse.getMessage());
            throw new ServiceException(10);
        }
    }

    public boolean delete() {
        boolean result = false;
        if (this.rs_YoutubeUser != null) {
            try {
                this.rs_YoutubeUser.closeRecordStore();
                RecordStore.deleteRecordStore((String)REC_STORE);
                result = true;
                this.rs_YoutubeUser = null;
                rmsAuthInstance = null;
            }
            catch (RecordStoreException rse) {
                Log.error("RecordStoreException deleting Record Store: " + rse.getMessage());
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean writeToken(String token) {
        boolean result = false;
        if (this.rs_YoutubeUser != null && token != null) {
            ByteArrayOutputStream strmBytes = new ByteArrayOutputStream();
            DataOutputStream strmDataType = new DataOutputStream(strmBytes);
            try {
                try {
                    strmDataType.writeUTF(token);
                    strmDataType.writeUTF(this.getName());
                    strmDataType.writeUTF(this.getLogin());
                    strmDataType.writeUTF(this.getPassword());
                    byte[] record = strmBytes.toByteArray();
                    if (this.rs_YoutubeUser.getNumRecords() == 0) {
                        this.rs_YoutubeUser.addRecord(record, 0, record.length);
                    } else {
                        this.rs_YoutubeUser.setRecord(1, record, 0, record.length);
                    }
                    strmBytes.reset();
                    strmDataType.flush();
                    result = true;
                }
                catch (RecordStoreException excp) {
                    Log.error("RecordStoreException writing data: " + excp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
                catch (IOException ioExcp) {
                    Log.error("IOException writing data: " + ioExcp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
            }
            finally {
                try {
                    strmBytes.close();
                    strmDataType.close();
                }
                catch (IOException ioexcp) {
                    Log.error("IOException closing stream: " + ioexcp.getMessage());
                }
            }
        }
        return result;
    }

    private boolean writeName(String name) {
        boolean result = false;
        if (this.rs_YoutubeUser != null && name != null) {
            ByteArrayOutputStream strmBytes = new ByteArrayOutputStream();
            DataOutputStream strmDataType = new DataOutputStream(strmBytes);
            try {
                try {
                    strmDataType.writeUTF(this.getToken());
                    strmDataType.writeUTF(name);
                    strmDataType.writeUTF(this.getLogin());
                    strmDataType.writeUTF(this.getPassword());
                    byte[] record = strmBytes.toByteArray();
                    if (this.rs_YoutubeUser.getNumRecords() == 0) {
                        this.rs_YoutubeUser.addRecord(record, 0, record.length);
                    } else {
                        this.rs_YoutubeUser.setRecord(1, record, 0, record.length);
                    }
                    strmBytes.reset();
                    strmDataType.flush();
                    result = true;
                }
                catch (RecordStoreException excp) {
                    Log.error("RecordStoreException writing data: " + excp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
                catch (IOException ioExcp) {
                    Log.error("IOException writing data: " + ioExcp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
            }
            finally {
                try {
                    strmBytes.close();
                    strmDataType.close();
                }
                catch (IOException ioexcp) {
                    Log.error("IOException closing stream: " + ioexcp.getMessage());
                }
            }
        }
        return result;
    }

    private boolean writeLogin(String login) {
        boolean result = false;
        if (this.rs_YoutubeUser != null && login != null) {
            ByteArrayOutputStream strmBytes = new ByteArrayOutputStream();
            DataOutputStream strmDataType = new DataOutputStream(strmBytes);
            try {
                try {
                    strmDataType.writeUTF(this.getToken());
                    strmDataType.writeUTF(this.getName());
                    strmDataType.writeUTF(login);
                    strmDataType.writeUTF(this.getPassword());
                    byte[] record = strmBytes.toByteArray();
                    if (this.rs_YoutubeUser.getNumRecords() == 0) {
                        this.rs_YoutubeUser.addRecord(record, 0, record.length);
                    } else {
                        this.rs_YoutubeUser.setRecord(1, record, 0, record.length);
                    }
                    strmBytes.reset();
                    strmDataType.flush();
                    result = true;
                }
                catch (RecordStoreException excp) {
                    Log.error("RecordStoreException writing data: " + excp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
                catch (IOException ioExcp) {
                    Log.error("IOException writing data: " + ioExcp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
            }
            finally {
                try {
                    strmBytes.close();
                    strmDataType.close();
                }
                catch (IOException ioexcp) {
                    Log.error("IOException closing stream: " + ioexcp.getMessage());
                }
            }
        }
        return result;
    }

    private boolean writePassword(String password) {
        boolean result = false;
        if (this.rs_YoutubeUser != null && password != null) {
            ByteArrayOutputStream strmBytes = new ByteArrayOutputStream();
            DataOutputStream strmDataType = new DataOutputStream(strmBytes);
            try {
                try {
                    strmDataType.writeUTF(this.getToken());
                    strmDataType.writeUTF(this.getName());
                    strmDataType.writeUTF(this.getLogin());
                    strmDataType.writeUTF(password);
                    byte[] record = strmBytes.toByteArray();
                    if (this.rs_YoutubeUser.getNumRecords() == 0) {
                        this.rs_YoutubeUser.addRecord(record, 0, record.length);
                    } else {
                        this.rs_YoutubeUser.setRecord(1, record, 0, record.length);
                    }
                    strmBytes.reset();
                    strmDataType.flush();
                    result = true;
                }
                catch (RecordStoreException excp) {
                    Log.error("RecordStoreException writing data: " + excp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
                catch (IOException ioExcp) {
                    Log.error("IOException writing data: " + ioExcp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
            }
            finally {
                try {
                    strmBytes.close();
                    strmDataType.close();
                }
                catch (IOException ioexcp) {
                    Log.error("IOException closing stream: " + ioexcp.getMessage());
                }
            }
        }
        return result;
    }

    private String read(int dataField) {
        String token = "";
        String name = "";
        String login = "";
        String password = "";
        try {
            block24: {
                if (this.rs_YoutubeUser != null && this.rs_YoutubeUser.getNumRecords() > 0) {
                    int dataSize = this.rs_YoutubeUser.getRecordSize(1);
                    byte[] recData = new byte[dataSize];
                    ByteArrayInputStream strmBytes = new ByteArrayInputStream(recData);
                    DataInputStream strmDataType = new DataInputStream(strmBytes);
                    try {
                        this.rs_YoutubeUser.getRecord(1, recData, 0);
                        token = strmDataType.readUTF();
                        name = strmDataType.readUTF();
                        login = strmDataType.readUTF();
                        password = strmDataType.readUTF();
                        strmBytes.reset();
                    }
                    catch (RecordStoreException excp) {
                        Log.error("RecordStoreException reading data: " + excp.getMessage());
                        try {
                            strmBytes.close();
                            strmDataType.close();
                        }
                        catch (IOException ioexcp) {
                            Log.error("IOException closing stream: " + ioexcp.getMessage());
                        }
                        break block24;
                    }
                    catch (IOException ioExcp) {
                        try {
                            Log.error("IOException reading data: " + ioExcp.getMessage());
                            break block24;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            try {
                                strmBytes.close();
                                strmDataType.close();
                            }
                            catch (IOException ioexcp) {
                                Log.error("IOException closing stream: " + ioexcp.getMessage());
                            }
                        }
                    }
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
            }
            switch (dataField) {
                case 0: {
                    return token;
                }
                case 1: {
                    return name;
                }
                case 2: {
                    return login;
                }
                case 3: {
                    return password;
                }
            }
            return "";
        }
        catch (RecordStoreException excp) {
            Log.error("RecordStoreException get recode size: " + excp.getMessage());
            return "";
        }
    }

    public boolean setToken(String token) {
        boolean result = false;
        if (token != null && token.length() > 0) {
            result = this.writeToken(token);
        }
        return result;
    }

    public boolean setName(String name) {
        boolean result = false;
        if (name != null && name.length() > 0) {
            result = this.writeName(name);
        }
        return result;
    }

    public boolean setLogin(String login) {
        boolean result = false;
        if (login != null && login.length() > 0) {
            result = this.writeLogin(login);
        }
        return result;
    }

    public boolean setPassword(String password) {
        boolean result = false;
        if (password != null && password.length() > 0) {
            result = this.writePassword(password);
        }
        return result;
    }

    public String getToken() {
        String token = "";
        token = this.read(0);
        return token;
    }

    public String getName() {
        String name = "";
        name = this.read(1);
        return name;
    }

    public String getLogin() {
        String login = "";
        login = this.read(2);
        return login;
    }

    public String getPassword() {
        String password = "";
        password = this.read(3);
        return password;
    }
}

