/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.midlet;

import com.sonyericsson.twitpic.controller.ApplicationListener;
import com.sonyericsson.twitpic.controller.MainController;
import com.sonyericsson.twitpic.service.action.CancelActionHandler;
import com.sonyericsson.twitpic.service.action.CapabilitiesActionHandler;
import com.sonyericsson.twitpic.service.action.InfoActionHandler;
import com.sonyericsson.twitpic.service.action.SignInActionHandler;
import com.sonyericsson.twitpic.service.action.SignOutActionHandler;
import com.sonyericsson.twitpic.service.action.UploadActionHandler;
import com.sonyericsson.twitpic.service.config.Config;
import com.sonyericsson.webalbum.action.ActionHandlerMap;
import com.sonyericsson.webalbum.codec.ContentCodec;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.codec.ImageResourceCodec;
import com.sonyericsson.webalbum.codec.ResourceCodec;
import com.sonyericsson.webalbum.invocation.InvocationHandler;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.log.ConsoleLogWriter;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.log.LogWriter;
import javax.microedition.content.ContentHandlerException;
import javax.microedition.content.ContentHandlerServer;
import javax.microedition.content.Registry;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class TwitPicMIDlet
extends MIDlet
implements ApplicationListener {
    private JobManager jobManager;
    private MainController controller;
    private int timeout = 10000;
    public static String logFile = "file:///E:/Log.txt";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        Log.info(this, "MIDlet method destroyApp invoked. Parameter unconditional = " + unconditional);
        this.controller.stop();
    }

    protected void pauseApp() {
        Log.info(this, "MIDlet method pauseApp invoked.");
    }

    protected void startApp() throws MIDletStateChangeException {
        boolean result = false;
        Log.setWriter(this.getLogWriter());
        this.configProperties();
        this.jobManager = new JobManager();
        ContentHandlerServer server = this.getServer();
        ActionHandlerMap actionHandlerMap = this.getActionHandlerMap();
        if (server != null && actionHandlerMap != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sonyericsson.webalbum.model.Content");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EntryCodec.registerCodec(clazz, new ContentCodec());
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.sonyericsson.webalbum.model.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceCodec.registerCodec(clazz2, new ResourceCodec());
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("com.sonyericsson.webalbum.model.ImageResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceCodec.registerCodec(clazz3, new ImageResourceCodec());
            InvocationHandler invocHandler = new InvocationHandler(server, this.timeout);
            if (invocHandler != null) {
                this.controller = new MainController(this, invocHandler, actionHandlerMap);
                this.controller.start();
                result = true;
            }
        }
        if (!result) {
            this.destroyApp(true);
        }
    }

    private void configProperties() {
        int logLevel = 0;
        String logLevelPropertyValue = this.getAppProperty("log-level");
        if (logLevelPropertyValue != null) {
            if (logLevelPropertyValue.equalsIgnoreCase("none")) {
                logLevel = 0;
            } else if (logLevelPropertyValue.equalsIgnoreCase("error")) {
                logLevel = 1;
            } else if (logLevelPropertyValue.equalsIgnoreCase("warning")) {
                logLevel = 2;
            } else if (logLevelPropertyValue.equalsIgnoreCase("info")) {
                logLevel = 3;
            } else if (logLevelPropertyValue.equalsIgnoreCase("trace")) {
                logLevel = 4;
            }
        }
        Log.setLevel(logLevel);
        Log.trace("Log-level value set to '" + logLevelPropertyValue + "'");
        String photoUploadSizeValue = this.getAppProperty("photo-upload-size");
        if (photoUploadSizeValue != null) {
            try {
                Config.setPhotoUploadSize(Integer.parseInt(photoUploadSizeValue));
            }
            catch (NumberFormatException nfe) {
                Log.error("NumberFormatException trying to parse cache goal size property to integer.");
            }
        } else {
            photoUploadSizeValue = Integer.toString(Config.getPhotoUploadSize());
        }
        Log.trace("PhotoUpload size property value set to " + photoUploadSizeValue);
        String timeoutPropertyValue = this.getAppProperty("timeout");
        if (timeoutPropertyValue != null) {
            try {
                this.timeout = Integer.parseInt(timeoutPropertyValue);
            }
            catch (NumberFormatException nfe) {
                Log.error("NumberFormatException trying to parse timeout property to integer.");
            }
        }
        Log.trace("Timeout property value set to " + this.timeout);
        String cacheGoalPropertyValue = this.getAppProperty("cache-goal-size");
        if (cacheGoalPropertyValue != null) {
            try {
                Config.setCacheGoalSize(Integer.parseInt(cacheGoalPropertyValue));
            }
            catch (NumberFormatException nfe) {
                Log.error("NumberFormatException trying to parse cache goal size property to integer.");
            }
        } else {
            cacheGoalPropertyValue = Integer.toString(Config.getCacheGoalSize());
        }
        Log.trace("Cache goal size property value set to " + cacheGoalPropertyValue);
    }

    protected ActionHandlerMap getActionHandlerMap() {
        ActionHandlerMap map = new ActionHandlerMap();
        map.addHandler("info", new InfoActionHandler());
        map.addHandler("capabilities", new CapabilitiesActionHandler());
        map.addHandler("sign-out", new SignOutActionHandler());
        map.addHandler("sign-in", new SignInActionHandler());
        map.addHandler("upload", new UploadActionHandler(this.jobManager));
        map.addHandler("cancel", new CancelActionHandler(this.jobManager));
        return map;
    }

    protected ContentHandlerServer getServer() {
        ContentHandlerServer server = null;
        try {
            server = Registry.getServer((String)this.getClass().getName());
        }
        catch (ContentHandlerException e) {
            Log.warning("Could not retrieve the handler for the static subscription: " + e.getMessage());
        }
        return server;
    }

    protected LogWriter getLogWriter() {
        return new ConsoleLogWriter();
    }
}

