/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.service.action;

import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public abstract class ActionUtil {
    public static void doHttpRequest(HttpRequest request) throws ServiceException {
        int result = 12;
        try {
            HttpUtil.doRequest(request);
            result = ActionUtil.resultFromHttpResponseCode(request.getResponseCode());
        }
        catch (IOException e) {
            result = 8;
        }
        if (result != 0) {
            throw new ServiceException(result);
        }
    }

    public static int resultFromHttpResponseCode(int responseCode) {
        int result = 12;
        switch (responseCode) {
            case 200: 
            case 201: {
                result = 0;
                break;
            }
            case 401: 
            case 403: {
                result = 5;
                break;
            }
            case 400: 
            case 404: {
                result = 2;
                break;
            }
            case 503: {
                result = 6;
                break;
            }
            case 500: {
                result = 7;
                break;
            }
            default: {
                result = 12;
            }
        }
        return result;
    }

    private static String getFullDir(String baseDir, String dir) {
        String fullDir;
        block6: {
            fullDir = baseDir.endsWith("/") ? String.valueOf(baseDir) + dir : String.valueOf(baseDir) + "/" + dir;
            FileConnection fc = null;
            try {
                try {
                    fc = (FileConnection)Connector.open((String)fullDir);
                    if (!fc.exists()) {
                        fc.mkdir();
                    }
                }
                catch (IOException iOException) {
                    IOUtil.closeConnection((Connection)fc);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeConnection(fc);
                throw throwable;
            }
            IOUtil.closeConnection((Connection)fc);
        }
        return fullDir;
    }

    public static String getTempDir(String baseDir) {
        return ActionUtil.getFullDir(baseDir, "temp");
    }
}

