/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.service.action;

import com.sonyericsson.twitpic.service.action.ActionUtil;
import com.sonyericsson.twitpic.service.http.SignInRequest;
import com.sonyericsson.twitpic.utils.OAuthUtil;
import com.sonyericsson.twitpic.utils.RMSStorage;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.StringMap;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SignInActionHandler
implements ActionHandler {
    private static final String ATTR_USER_NICKNAME = "user:nickname";
    private static final String ATTR_USER_NAME = "user:name";
    private static final String LOG_PREFIX = "SignInActionHandler: ";
    private static final String VALUE_CREDENTIALS_STATUS_BAD_CREDENTIALS = "bad credentials";
    private static final String VALUE_CREDENTIALS_STATUS_BAD_TIME_CREDENTIALS = "bad time credentials";
    private static final String VALUE_CREDENTIALS_STATUS_AUTHORIZED = "authorized";
    private static final String ATTR_AUTH_STATUS = "auth:status";
    private static final String ATTR_USER_LOGIN = "user:login";
    private static final String ATTR_USER_PASSWORD = "user:password";
    private String accessPointId = null;
    private RMSStorage rmsStorage;

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        Object requestUrl = null;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = new Attributes();
        try {
            String login = AttributeCodec.decodeAttribute(inAttr.get(ATTR_USER_LOGIN));
            String password = AttributeCodec.decodeAttribute(inAttr.get(ATTR_USER_PASSWORD));
            this.accessPointId = inAttr.get("access-point-id");
            StringMap oauthParameterMap = this.createOauthParameterMap();
            StringMap apiParameterMap = this.createApiParameterMap(password, login);
            String signatureBaseString = OAuthUtil.getSignatureBaseString("POST", "https://api.twitter.com/oauth/access_token", oauthParameterMap, apiParameterMap);
            String key = OAuthUtil.getKeyString();
            String signature = OAuthUtil.getSignature(signatureBaseString, key);
            String headers = OAuthUtil.createHeaders(null, oauthParameterMap, signature);
            String bodyString = this.createBodyString(apiParameterMap);
            SignInRequest sir = new SignInRequest("POST", "https://api.twitter.com/oauth/access_token", this.SignInCreateHeaders(headers), bodyString);
            try {
                HttpUtil.doRequest(sir);
                result = ActionUtil.resultFromHttpResponseCode(sir.getResponseCode());
            }
            catch (IOException e) {
                result = 8;
            }
            switch (result) {
                case 0: {
                    if (sir.getAuthStatus() == 0) {
                        this.rmsStorage = RMSStorage.getRMSStorage();
                        StringMap storeList = new StringMap();
                        storeList.put(Integer.toString(0), sir.getScreenName());
                        storeList.put(Integer.toString(1), password);
                        storeList.put(Integer.toString(2), sir.getToken());
                        storeList.put(Integer.toString(3), sir.getTokenSecret());
                        storeList.put(Integer.toString(4), sir.getUserId());
                        storeList.put(Integer.toString(5), sir.getScreenName());
                        storeList.put(Integer.toString(6), sir.getAuthExpires());
                        this.rmsStorage.setAllData(storeList);
                        outAttr.set(ATTR_AUTH_STATUS, VALUE_CREDENTIALS_STATUS_AUTHORIZED);
                        outAttr.set(ATTR_USER_NICKNAME, AttributeCodec.encodeAttribute(sir.getScreenName()));
                        outAttr.set(ATTR_USER_NAME, AttributeCodec.encodeAttribute(sir.getScreenName()));
                        break;
                    }
                    result = 12;
                    break;
                }
                case 5: {
                    if (sir.getAuthStatus() == 1) {
                        outAttr.set(ATTR_AUTH_STATUS, VALUE_CREDENTIALS_STATUS_BAD_TIME_CREDENTIALS);
                        outAttr.set(ATTR_USER_LOGIN, login);
                        result = 0;
                        break;
                    }
                    result = 12;
                    break;
                }
            }
        }
        catch (ServiceException se) {
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }

    private StringMap createOauthParameterMap() {
        StringMap oauthParameterMap = new StringMap();
        oauthParameterMap.put("oauth_consumer_key", "QHvektt9aezYcBwjFcMyIg");
        oauthParameterMap.put("oauth_nonce", OAuthUtil.getNonce());
        oauthParameterMap.put("oauth_signature_method", "HMAC-SHA1");
        oauthParameterMap.put("oauth_timestamp", OAuthUtil.getTimeStamp());
        oauthParameterMap.put("oauth_version", "1.0");
        return oauthParameterMap;
    }

    private StringMap createApiParameterMap(String password, String login) {
        StringMap apiParameterMap = new StringMap();
        apiParameterMap.put("x_auth_mode", "client_auth");
        apiParameterMap.put("x_auth_password", OAuthUtil.URLEncode(password));
        apiParameterMap.put("x_auth_username", OAuthUtil.URLEncode(login));
        return apiParameterMap;
    }

    private String createBodyString(StringMap apimap) {
        StringBuffer stringBuf = new StringBuffer();
        Enumeration apikeys = apimap.keys();
        while (apikeys.hasMoreElements()) {
            String name = (String)apikeys.nextElement();
            stringBuf.append(name).append("=").append(apimap.get(name)).append("&");
        }
        return stringBuf.toString().substring(0, stringBuf.length() - 1);
    }

    public Hashtable SignInCreateHeaders(String authToken) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("Authorization", authToken);
        return headers;
    }
}

