/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.service.action;

import com.sonyericsson.twitpic.service.action.ActionUtil;
import com.sonyericsson.twitpic.service.config.Config;
import com.sonyericsson.twitpic.service.http.UploadPhotoRequest;
import com.sonyericsson.twitpic.service.xml.UploadLinkParser;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.TransferJob;
import com.sonyericsson.webalbum.service.transfer.TransferRequestProgressListener;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.util.MediaUtil;
import com.sonyericsson.webalbum.util.MimeUtil;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.media.MediaException;

public class UploadJob
extends TransferJob
implements TransferRequestProgressListener {
    private static final int UPLOAD_PROGRESS_INTERVAL = 10240;
    private String header;
    private String baseDir;
    private String strUrl;
    private Vector uploadedVideoIdVector = new Vector();
    private boolean disableResize = false;

    protected UploadJob(int id, UploadItem[] items, String baseDir, String header) {
        super(id, items);
        this.baseDir = baseDir;
        this.header = header;
        this.strUrl = null;
    }

    protected int transferCurrentItem() {
        UploadItem item = (UploadItem)this.getCurrentItem();
        Entry entry = item.getEntry();
        item.setState(2);
        return this.uploadContent((Content)entry);
    }

    private int uploadContent(Content content) {
        int result;
        block30: {
            String tempUrl;
            block31: {
                UploadItem item;
                block32: {
                    result = 12;
                    item = (UploadItem)this.getCurrentItem();
                    int fileSize = 0;
                    tempUrl = null;
                    try {
                        Log.trace("UploadJob#uploadContent: Starting upload");
                        Resource resource = content.getResource("content");
                        if (resource == null) {
                            throw new ServiceException(2);
                        }
                        String localUrl = resource.getLocalUrl();
                        if (localUrl == null) {
                            throw new ServiceException(4);
                        }
                        if (localUrl.length() <= 0) {
                            throw new ServiceException(2);
                        }
                        String title = content.getTitle();
                        String description = content.getDescription();
                        String access = content.getAccess();
                        String keyWords = content.getKeywords();
                        String contentType = this.getContentType(localUrl);
                        String disableResize = content.getDisableResize();
                        Log.trace(this, "Disable resize param value: " + disableResize);
                        if (disableResize == null) {
                            disableResize = "false";
                        }
                        Log.trace("Disable downscaling: " + disableResize);
                        if ("image/jpeg".equals(contentType) && disableResize.equalsIgnoreCase("false")) {
                            int maxWidthOrHeight = Math.min(1600, Config.getPhotoUploadSize());
                            tempUrl = this.createTempUrl(this.baseDir);
                            try {
                                if (MediaUtil.resizeImage(localUrl, contentType, maxWidthOrHeight, tempUrl)) {
                                    Log.trace("Image resized. New url: " + tempUrl);
                                    localUrl = tempUrl;
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                Log.error(this, "IOException: Error resizing the Image before upload.");
                                throw new ServiceException(9);
                            }
                            catch (MediaException e) {
                                Log.error(this, "MediaException: Error resizing the Image before upload.");
                                throw new ServiceException(9);
                            }
                        }
                        fileSize = IOUtil.getFileSize(localUrl);
                        item.setTotalNrBytes(fileSize);
                        UploadLinkParser upParser = new UploadLinkParser();
                        this.currentRequest = new UploadPhotoRequest(upParser, content, "http://api.twitpic.com/2/upload.xml", contentType, this.UploadCreateHeaders(this.header));
                        this.currentRequest.setTransferRequestProgressListener(this, 10240);
                        if (this.cancelled) {
                            Log.trace(this, "Cancelled request");
                            this.currentRequest.cancel();
                        } else {
                            result = ((UploadPhotoRequest)this.currentRequest).doRequest();
                        }
                    }
                    catch (ServiceException e) {
                        Log.logException(e);
                        result = e.getResult();
                        if (!this.cancelled && result == 0) {
                            item.setCurrentNrBytes(fileSize);
                            item.setState(5);
                        } else if (this.cancelled || this.currentRequest != null && this.currentRequest.isCancelled()) {
                            Log.trace("Cancelling current Request");
                            item.setState(3);
                            result = 1;
                            Log.trace("" + item.getState());
                        } else {
                            item.setState(4);
                        }
                        this.currentRequest = null;
                        if (tempUrl != null) {
                            IOUtil.deleteFile(tempUrl);
                        }
                        break block30;
                    }
                    catch (Exception ex) {
                        try {
                            Log.logException(ex);
                            break block30;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (!this.cancelled && result == 0) {
                                item.setCurrentNrBytes(fileSize);
                                item.setState(5);
                            } else if (this.cancelled || this.currentRequest != null && this.currentRequest.isCancelled()) {
                                Log.trace("Cancelling current Request");
                                item.setState(3);
                                result = 1;
                                Log.trace("" + item.getState());
                            } else {
                                item.setState(4);
                            }
                            this.currentRequest = null;
                            if (tempUrl != null) {
                                IOUtil.deleteFile(tempUrl);
                            }
                        }
                    }
                    if (!this.cancelled && result == 0) {
                        item.setCurrentNrBytes(fileSize);
                        item.setState(5);
                        break block31;
                    }
                    if (!this.cancelled && (this.currentRequest == null || !this.currentRequest.isCancelled())) break block32;
                    Log.trace("Cancelling current Request");
                    item.setState(3);
                    result = 1;
                    Log.trace("" + item.getState());
                    break block31;
                }
                item.setState(4);
            }
            this.currentRequest = null;
            if (tempUrl != null) {
                IOUtil.deleteFile(tempUrl);
            }
        }
        return result;
    }

    private Hashtable UploadCreateHeaders(String authToken) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        headers.put("X-Verify-Credentials-Authorization", authToken);
        headers.put("X-Auth-Service-Provider", "https://api.twitter.com/1/account/verify_credentials.json");
        return headers;
    }

    private String getContentType(String localUrl) {
        String contentType = MimeUtil.getContentTypeFromUrl(localUrl);
        return contentType;
    }

    private String createTempUrl(String localUrl) {
        return String.valueOf(ActionUtil.getTempDir(this.baseDir)) + "/temp" + System.currentTimeMillis();
    }

    public Vector getUploadedVideoIdVector() {
        return this.uploadedVideoIdVector;
    }
}

