/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.service.http;

import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.StringMap;
import com.sonyericsson.webalbum.util.StringUtil;
import com.sonyericsson.webalbum.xml.XmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class SignInRequest
extends HttpRequest {
    protected XmlParser parser;
    protected String requestUrl = "";
    public static final int AUTH_STATUS_AUTHORIZED = 0;
    public static final int AUTH_STATUS_BAD_AUTHENTICATION = 1;
    public static final int AUTH_STATUS_NOT_ACTIVE = 2;
    public static final int AUTH_STATUS_CAPTCHA_REQUIRED = 3;
    public static final int AUTH_STATUS_TEMPORARY_ERROR = 4;
    public static final int AUTH_STATUS_UNKNOWN_ERROR = 5;
    private int authStatus = 5;
    private byte[] bodyBytes;
    private String authToken;
    private String authTokenSecret;
    private String userId;
    private String screenName;
    private String authExpires;

    public SignInRequest(String method, String url, Hashtable headers, String body) {
        super(method, url, headers);
        this.requestUrl = url;
        Log.trace(this, "Body = " + body);
        try {
            this.bodyBytes = body.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.addHeader("Content-Type", "application/x-www-form-urlencoded");
        this.addHeader("Content-Length", String.valueOf(this.bodyBytes.length));
    }

    public void writeBody(OutputStream os) throws IOException {
        os.write(this.bodyBytes);
    }

    public void readResponseBody(InputStream is) throws IOException {
        if (this.getResponseCode() == 200 || this.getResponseCode() == 201) {
            StringMap parameters = StringUtil.splitKeyValue(is, "&");
            if (parameters != null) {
                this.authStatus = 0;
                this.authToken = parameters.get("oauth_token");
                Log.trace(this, "oauth_token=" + this.authToken);
                if (this.authToken == null) {
                    this.authStatus = 1;
                    return;
                }
                this.authTokenSecret = parameters.get("oauth_token_secret");
                Log.trace(this, "oauth_token_secret=" + this.authTokenSecret);
                if (this.authTokenSecret == null) {
                    this.authStatus = 1;
                    return;
                }
                this.userId = parameters.get("user_id");
                Log.trace(this, "user_id=" + this.userId);
                this.screenName = parameters.get("screen_name");
                Log.trace(this, "screen_name=" + this.screenName);
                this.authExpires = parameters.get("x_auth_expires");
                Log.trace(this, "x_auth_expires=" + this.authExpires);
            }
        } else if (this.getResponseCode() == 401) {
            this.authStatus = 1;
        }
    }

    public int getAuthStatus() {
        return this.authStatus;
    }

    public String getToken() {
        return this.authToken;
    }

    public String getTokenSecret() {
        return this.authTokenSecret;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getAuthExpires() {
        return this.authExpires;
    }
}

