/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.service.http;

import com.sonyericsson.twitpic.service.action.ActionHandlerUtil;
import com.sonyericsson.twitpic.service.xml.UploadLinkParser;
import com.sonyericsson.webalbum.http.ConnectionFactory;
import com.sonyericsson.webalbum.http.DefaultConnectionFactory;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.service.transfer.TransferRequest;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.xml.XmlException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public class UploadPhotoRequest
extends TransferRequest {
    UploadLinkParser parser = null;
    static final String BOUNDARY = "----------V2ymHFg03ehbqgZCaKO6jy";
    static final String FileField = "media";
    byte[] postBytes = null;
    String url = null;
    private Hashtable header;
    private String description = null;
    private String PhotoFileName = null;
    private String uploadFileUrl = null;
    private static ConnectionFactory connectionFactory = new DefaultConnectionFactory();
    private String fileType = null;
    String bodyPart = null;
    String closingPart = null;
    boolean isUploadPost = false;
    private HttpConnection conn = null;
    private FileConnection fc = null;
    private InputStream imgIs = null;

    public UploadPhotoRequest(UploadLinkParser parser, Content content, String strURL, String fileType, Hashtable header) throws Exception {
        super("POST", strURL, header, 1024);
        String endBoundary;
        String boundaryMessage;
        this.fileType = fileType;
        this.url = strURL;
        this.header = header;
        if (content == null) {
            Log.error(this, "Invalid parameters passed in request constructor");
            throw new IllegalArgumentException("Invalid parameters passed in request constructor");
        }
        Resource resource = content.getResource("content");
        this.uploadFileUrl = resource.getLocalUrl();
        this.PhotoFileName = this.uploadFileUrl.substring(this.uploadFileUrl.lastIndexOf(47) + 1);
        this.description = content.getDescription();
        this.parser = parser;
        this.bodyPart = boundaryMessage = this.getBoundaryMessage();
        this.closingPart = endBoundary = "\r\n------------V2ymHFg03ehbqgZCaKO6jy--\r\n";
    }

    private String getBoundaryString() {
        return BOUNDARY;
    }

    private String getBoundaryMessage() {
        String boundary = this.getBoundaryString();
        StringBuffer res = new StringBuffer("--").append(boundary).append("\r\n");
        res.append("Content-Disposition: form-data; name=\"").append("key").append("\"\r\n").append("\r\n").append("29d8047749b1ff9ed23f5a55effda101").append("\r\n").append("--").append(boundary).append("\r\n");
        if (this.description.length() > 0) {
            res.append("Content-Disposition: form-data; name=\"").append("message").append("\"\r\n").append("\r\n").append(this.description).append("\r\n").append("--").append(boundary).append("\r\n");
        }
        res.append("Content-Disposition: file; name=\"").append(FileField).append("\"; filename=\"").append(this.PhotoFileName).append("\"\r\n").append("Content-Type: ").append(this.fileType).append("\r\n\r\n");
        return res.toString();
    }

    public int doRequest() {
        int result = 12;
        OutputStream os = null;
        InputStream is = null;
        long bytesToRead = 0L;
        String errorCode = "";
        String contentLength = "";
        byte[] resbytes = new byte[1024];
        try {
            Log.trace("Upload PhotoRequest do Request" + this.uploadFileUrl);
            this.fc = (FileConnection)Connector.open((String)this.uploadFileUrl, (int)1);
            this.imgIs = this.fc.openInputStream();
            bytesToRead = this.fc.fileSize();
        }
        catch (IOException ioe) {
            Log.error("Exception" + ioe.getMessage());
            result = 9;
        }
        if (result != 9) {
            block46: {
                try {
                    this.conn = (HttpConnection)connectionFactory.open(this.url);
                    this.conn.setRequestMethod("POST");
                    this.conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.getBoundaryString());
                    this.conn.setRequestProperty("Host", "api.twitpic.com");
                    contentLength = String.valueOf((long)(this.bodyPart.toString().getBytes("UTF-8").length + this.closingPart.length()) + bytesToRead);
                    this.conn.setRequestProperty("Content-Length", contentLength);
                    UploadPhotoRequest.setRequestHeaders(this.conn, this.header);
                }
                catch (IOException connIoe) {
                    Log.error("IOException opening connection to Twitpic: " + connIoe.getMessage());
                    result = 8;
                }
                catch (Exception ex) {
                    Log.error("Exception opening connection to Twitpic: " + ex.getMessage());
                    result = 8;
                }
                if (result != 8) {
                    try {
                        try {
                            os = this.conn.openOutputStream();
                            os.write(this.bodyPart.toString().getBytes("UTF-8"));
                            Log.info(this.bodyPart.toString());
                            this.copyStream(this.imgIs, os);
                            os.write(this.closingPart.getBytes());
                        }
                        catch (IOException ioe) {
                            Log.error("IOException uploading file: " + ioe.getMessage());
                            result = 8;
                            try {
                                os.close();
                            }
                            catch (IOException ioe2) {
                                Log.error("IOException closing streams: " + ioe2.getMessage());
                            }
                            break block46;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            os.close();
                        }
                        catch (IOException ioe) {
                            Log.error("IOException closing streams: " + ioe.getMessage());
                        }
                        throw throwable;
                    }
                    try {
                        os.close();
                    }
                    catch (IOException ioe) {
                        Log.error("IOException closing streams: " + ioe.getMessage());
                    }
                }
            }
            if (result != 8) {
                try {
                    try {
                        is = this.conn.openInputStream();
                        Log.error(this, "Response Received");
                        this.parser.parse(is);
                        errorCode = this.parser.getErrorCode();
                        result = ActionHandlerUtil.mapErrorCode(errorCode);
                        if (result != 0) {
                            Log.error("Response Parsed with errorcode: " + errorCode + " " + this.parser.getErrMessage());
                        }
                    }
                    catch (IOException ioe) {
                        Log.error("IOException receiving response: " + ioe.getMessage());
                        result = 8;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException ioe3) {
                            Log.error("IOException closing InputStream: " + ioe3.getMessage());
                            result = 8;
                        }
                        catch (NullPointerException npe) {
                            Log.error("NullPointerException closing InputStream: " + ((Throwable)npe).getMessage());
                        }
                        catch (Exception ex) {
                            Log.error("Exception closing InputStream: " + ex.getMessage());
                        }
                        Log.info(this, "Closing Connections");
                        IOUtil.closeConnection((Connection)this.conn);
                        IOUtil.closeInputStream(this.imgIs);
                        IOUtil.closeConnection((Connection)this.fc);
                        Log.info(this, "Closed Connections");
                    }
                    catch (XmlException xmle) {
                        Log.error("XmlException parsing response: " + xmle.getMessage());
                        result = 7;
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException ioe) {
                            Log.error("IOException closing InputStream: " + ioe.getMessage());
                            result = 8;
                        }
                        catch (NullPointerException npe) {
                            Log.error("NullPointerException closing InputStream: " + ((Throwable)npe).getMessage());
                        }
                        catch (Exception ex) {
                            Log.error("Exception closing InputStream: " + ex.getMessage());
                        }
                        Log.info(this, "Closing Connections");
                        IOUtil.closeConnection((Connection)this.conn);
                        IOUtil.closeInputStream(this.imgIs);
                        IOUtil.closeConnection((Connection)this.fc);
                        Log.info(this, "Closed Connections");
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ioe) {
                        Log.error("IOException closing InputStream: " + ioe.getMessage());
                        result = 8;
                    }
                    catch (NullPointerException npe) {
                        Log.error("NullPointerException closing InputStream: " + ((Throwable)npe).getMessage());
                    }
                    catch (Exception ex) {
                        Log.error("Exception closing InputStream: " + ex.getMessage());
                    }
                    Log.info(this, "Closing Connections");
                    IOUtil.closeConnection((Connection)this.conn);
                    IOUtil.closeInputStream(this.imgIs);
                    IOUtil.closeConnection((Connection)this.fc);
                    Log.info(this, "Closed Connections");
                }
            }
        }
        return result;
    }

    private static void setRequestHeaders(HttpConnection conn, Hashtable headers) throws IOException {
        if (headers != null) {
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                String property = (String)keys.nextElement();
                String value = (String)headers.get(property);
                Log.trace("HttpUtil#setRequestHeaders: '" + property + ": " + value + "'");
                conn.setRequestProperty(property, value);
            }
        }
    }
}

