/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.utils;

public class HMACSHA1 {
    private final int[] abcde = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
    private int[] digestInt = new int[5];
    private int[] tmpData = new int[80];

    public byte[] getHmacSHA1(String data, String key) {
        int i;
        byte[] temp;
        byte[] ipadArray = new byte[64];
        byte[] opadArray = new byte[64];
        byte[] keyArray = new byte[64];
        int ex = key.length();
        if (key.length() > 64) {
            temp = this.getDigestOfBytes(key.getBytes());
            ex = temp.length;
            i = 0;
            while (i < ex) {
                keyArray[i] = temp[i];
                ++i;
            }
        } else {
            temp = key.getBytes();
            i = 0;
            while (i < temp.length) {
                keyArray[i] = temp[i];
                ++i;
            }
        }
        int i2 = ex;
        while (i2 < 64) {
            keyArray[i2] = 0;
            ++i2;
        }
        int j = 0;
        while (j < 64) {
            ipadArray[j] = (byte)(keyArray[j] ^ 0x36);
            opadArray[j] = (byte)(keyArray[j] ^ 0x5C);
            ++j;
        }
        byte[] tempResult = this.getDigestOfBytes(HMACSHA1.join(ipadArray, data.getBytes()));
        return this.getDigestOfBytes(HMACSHA1.join(opadArray, tempResult));
    }

    private static byte[] join(byte[] b1, byte[] b2) {
        int length = b1.length + b2.length;
        byte[] newer = new byte[length];
        int i = 0;
        while (i < b1.length) {
            newer[i] = b1[i];
            ++i;
        }
        i = 0;
        while (i < b2.length) {
            newer[i + b1.length] = b2[i];
            ++i;
        }
        return newer;
    }

    private int process_input_bytes(byte[] bytedata) {
        System.arraycopy(this.abcde, 0, this.digestInt, 0, this.abcde.length);
        byte[] newbyte = this.byteArrayFormatData(bytedata);
        int MCount = newbyte.length / 64;
        int pos = 0;
        while (pos < MCount) {
            int j = 0;
            while (j < 16) {
                this.tmpData[j] = this.byteArrayToInt(newbyte, pos * 64 + j * 4);
                ++j;
            }
            this.encrypt();
            ++pos;
        }
        return 20;
    }

    private byte[] byteArrayFormatData(byte[] bytedata) {
        int zeros = 0;
        int size = 0;
        int n = bytedata.length;
        int m = n % 64;
        if (m < 56) {
            zeros = 55 - m;
            size = n - m + 64;
        } else if (m == 56) {
            zeros = 63;
            size = n + 8 + 64;
        } else {
            zeros = 63 - m + 56;
            size = n + 64 - m + 64;
        }
        byte[] newbyte = new byte[size];
        System.arraycopy(bytedata, 0, newbyte, 0, n);
        int l = n;
        newbyte[l++] = -128;
        int i = 0;
        while (i < zeros) {
            newbyte[l++] = 0;
            ++i;
        }
        long N = (long)n * 8L;
        byte h8 = (byte)(N & 0xFFL);
        byte h7 = (byte)(N >> 8 & 0xFFL);
        byte h6 = (byte)(N >> 16 & 0xFFL);
        byte h5 = (byte)(N >> 24 & 0xFFL);
        byte h4 = (byte)(N >> 32 & 0xFFL);
        byte h3 = (byte)(N >> 40 & 0xFFL);
        byte h2 = (byte)(N >> 48 & 0xFFL);
        byte h1 = (byte)(N >> 56);
        newbyte[l++] = h1;
        newbyte[l++] = h2;
        newbyte[l++] = h3;
        newbyte[l++] = h4;
        newbyte[l++] = h5;
        newbyte[l++] = h6;
        newbyte[l++] = h7;
        newbyte[l++] = h8;
        return newbyte;
    }

    private int f1(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private int f2(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private int f3(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private int f4(int x, int y) {
        return x << y | x >>> 32 - y;
    }

    private void encrypt() {
        int tmp;
        int i = 16;
        while (i <= 79) {
            this.tmpData[i] = this.f4(this.tmpData[i - 3] ^ this.tmpData[i - 8] ^ this.tmpData[i - 14] ^ this.tmpData[i - 16], 1);
            ++i;
        }
        int[] tmpabcde = new int[5];
        int i1 = 0;
        while (i1 < tmpabcde.length) {
            tmpabcde[i1] = this.digestInt[i1];
            ++i1;
        }
        int j = 0;
        while (j <= 19) {
            tmp = this.f4(tmpabcde[0], 5) + this.f1(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] + this.tmpData[j] + 1518500249;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = this.f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
            ++j;
        }
        int k = 20;
        while (k <= 39) {
            tmp = this.f4(tmpabcde[0], 5) + this.f2(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] + this.tmpData[k] + 1859775393;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = this.f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
            ++k;
        }
        int l = 40;
        while (l <= 59) {
            tmp = this.f4(tmpabcde[0], 5) + this.f3(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] + this.tmpData[l] + -1894007588;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = this.f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
            ++l;
        }
        int m = 60;
        while (m <= 79) {
            tmp = this.f4(tmpabcde[0], 5) + this.f2(tmpabcde[1], tmpabcde[2], tmpabcde[3]) + tmpabcde[4] + this.tmpData[m] + -899497514;
            tmpabcde[4] = tmpabcde[3];
            tmpabcde[3] = tmpabcde[2];
            tmpabcde[2] = this.f4(tmpabcde[1], 30);
            tmpabcde[1] = tmpabcde[0];
            tmpabcde[0] = tmp;
            ++m;
        }
        int i2 = 0;
        while (i2 < tmpabcde.length) {
            this.digestInt[i2] = this.digestInt[i2] + tmpabcde[i2];
            ++i2;
        }
        int n = 0;
        while (n < this.tmpData.length) {
            this.tmpData[n] = 0;
            ++n;
        }
    }

    private int byteArrayToInt(byte[] bytedata, int i) {
        return (bytedata[i] & 0xFF) << 24 | (bytedata[i + 1] & 0xFF) << 16 | (bytedata[i + 2] & 0xFF) << 8 | bytedata[i + 3] & 0xFF;
    }

    private void intToByteArray(int intValue, byte[] byteData, int i) {
        byteData[i] = (byte)(intValue >>> 24);
        byteData[i + 1] = (byte)(intValue >>> 16);
        byteData[i + 2] = (byte)(intValue >>> 8);
        byteData[i + 3] = (byte)intValue;
    }

    private static String byteToHexString(byte ib) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] ob = new char[]{Digit[ib >>> 4 & 0xF], Digit[ib & 0xF]};
        String s = new String(ob);
        return s;
    }

    private static String byteArrayToHexString(byte[] bytearray) {
        String strDigest = "";
        int i = 0;
        while (i < bytearray.length) {
            strDigest = String.valueOf(strDigest) + HMACSHA1.byteToHexString(bytearray[i]);
            ++i;
        }
        return strDigest;
    }

    private byte[] getDigestOfBytes(byte[] byteData) {
        this.process_input_bytes(byteData);
        byte[] digest = new byte[20];
        int i = 0;
        while (i < this.digestInt.length) {
            this.intToByteArray(this.digestInt[i], digest, i * 4);
            ++i;
        }
        return digest;
    }

    private String getDigestOfString(byte[] byteData) {
        return HMACSHA1.byteArrayToHexString(this.getDigestOfBytes(byteData));
    }
}

