/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.utils;

import com.sonyericsson.twitpic.utils.Base64Encode;
import com.sonyericsson.twitpic.utils.HMACSHA1;
import com.sonyericsson.twitpic.utils.RMSStorage;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.StringMap;
import java.util.Enumeration;
import java.util.Random;

public class OAuthUtil {
    private static RMSStorage rmsStorage;

    public static String createHeaders(String realm, StringMap map, String signature) {
        StringBuffer stringBuffer = new StringBuffer();
        if (realm == null) {
            stringBuffer.append("OAuth ");
        } else {
            stringBuffer.append("OAuth realm=").append("\"").append(realm).append("\",");
        }
        Enumeration keys = map.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            stringBuffer.append(name).append("=").append("\"").append(map.get(name)).append("\",");
        }
        stringBuffer.append("oauth_signature").append("=").append("\"").append(signature).append("\"");
        return stringBuffer.toString();
    }

    public static String getSignatureBaseString(String method, String url, StringMap map, StringMap apimap) {
        StringBuffer stringBuf = new StringBuffer();
        stringBuf.append(method).append("&").append(OAuthUtil.URLEncode(url)).append("&");
        StringBuffer preStringBuf = new StringBuffer();
        Enumeration keys = map.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            preStringBuf.append(name).append("=").append(map.get(name)).append("&");
        }
        if (apimap != null) {
            Enumeration apikeys = apimap.keys();
            while (apikeys.hasMoreElements()) {
                String name = (String)apikeys.nextElement();
                preStringBuf.append(name).append("=").append(apimap.get(name)).append("&");
            }
        }
        stringBuf.append(OAuthUtil.URLEncode(preStringBuf.toString().substring(0, preStringBuf.length() - 1)));
        return stringBuf.toString();
    }

    public static String getSignature(String signatureBaseString, String keyString) {
        Log.trace("OAuth: keyString = " + keyString);
        Log.trace("OAuth: signatureBaseString = " + signatureBaseString);
        String signature = null;
        HMACSHA1 hmacsha1 = new HMACSHA1();
        byte[] digest = hmacsha1.getHmacSHA1(signatureBaseString, keyString);
        signature = OAuthUtil.URLEncode(Base64Encode.encode(digest));
        return signature;
    }

    public static String getKeyString() throws ServiceException {
        rmsStorage = RMSStorage.getRMSStorage();
        String oAuthTokenSecret = rmsStorage.getOAuthTokenSecret();
        if (oAuthTokenSecret == null) {
            return "6xYfxz8SLR4wABb0qgA1CwE68MQMGTPHYJDIJUz4&";
        }
        return "6xYfxz8SLR4wABb0qgA1CwE68MQMGTPHYJDIJUz4&" + oAuthTokenSecret;
    }

    public static String getNonce() {
        String baseChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer stringBuf = new StringBuffer();
        int i = 0;
        while (i < 11) {
            int val = random.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".length());
            stringBuf.append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".charAt(val));
            ++i;
        }
        return stringBuf.toString();
    }

    public static String getTimeStamp() {
        return new Long(System.currentTimeMillis() / 1000L).toString();
    }

    public static String URLEncode(String in) {
        StringBuffer inBuf = new StringBuffer(in);
        StringBuffer outBuf = new StringBuffer();
        int i = 0;
        while (i < inBuf.length()) {
            char temp = inBuf.charAt(i);
            if ('a' <= temp && temp <= 'z' || 'A' <= temp && temp <= 'Z' || '0' <= temp && temp <= '9' || temp == '.' || temp == '-' || temp == '~' || temp == '_') {
                outBuf.append(temp);
            } else if (temp == ' ') {
                outBuf.append('+');
            } else {
                try {
                    byte[] bytes = new String(new char[]{temp}).getBytes("UTF-8");
                    int j = 0;
                    while (j < bytes.length) {
                        int high = bytes[j] >>> 4 & 0xF;
                        int low = bytes[j] & 0xF;
                        outBuf.append('%');
                        outBuf.append(Integer.toString(high, 16).toUpperCase());
                        outBuf.append(Integer.toString(low, 16).toUpperCase());
                        ++j;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
        return outBuf.toString();
    }
}

