/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.twitpic.utils;

import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.StringMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RMSStorage {
    private RecordStore rs_TwitpicUser;
    static final String REC_STORE = "UserInfo";
    private static final int RECORD_ID = 1;
    public static final int LOGIN_FIELD = 0;
    public static final int PASSWORD_FIELD = 1;
    public static final int OAUTH_TOKEN_FIELD = 2;
    public static final int OAUTH_TOKEN_SECRET_FIELD = 3;
    public static final int USER_ID_FIELD = 4;
    public static final int SCREEN_NAME_FIELD = 5;
    public static final int X_AUTH_EXPIRES_FIELD = 6;
    private static RMSStorage rmsAuthInstance;

    private RMSStorage() throws ServiceException {
        this.open();
    }

    public static RMSStorage getRMSStorage() throws ServiceException {
        if (rmsAuthInstance == null) {
            rmsAuthInstance = new RMSStorage();
        }
        return rmsAuthInstance;
    }

    private void open() throws ServiceException {
        try {
            this.rs_TwitpicUser = RecordStore.openRecordStore((String)REC_STORE, (boolean)true);
        }
        catch (RecordStoreException rse) {
            Log.error("RecordStoreException opening Record Store: " + rse.getMessage());
            throw new ServiceException(10);
        }
    }

    public boolean delete() {
        boolean result = false;
        if (this.rs_TwitpicUser != null) {
            try {
                this.rs_TwitpicUser.closeRecordStore();
                RecordStore.deleteRecordStore((String)REC_STORE);
                result = true;
                this.rs_TwitpicUser = null;
                rmsAuthInstance = null;
            }
            catch (RecordStoreException rse) {
                Log.error("RecordStoreException deleting Record Store: " + rse.getMessage());
            }
        } else {
            result = true;
        }
        return result;
    }

    private boolean writeAllData(StringMap storeListData) {
        boolean result = false;
        if (this.rs_TwitpicUser != null && storeListData != null) {
            ByteArrayOutputStream strmBytes = new ByteArrayOutputStream();
            DataOutputStream strmDataType = new DataOutputStream(strmBytes);
            try {
                try {
                    String login = storeListData.get(Integer.toString(0));
                    String password = storeListData.get(Integer.toString(1));
                    String oauthToken = storeListData.get(Integer.toString(2));
                    String oauthTokenSecret = storeListData.get(Integer.toString(3));
                    String userId = storeListData.get(Integer.toString(4));
                    String screenName = storeListData.get(Integer.toString(5));
                    String xauthExpires = storeListData.get(Integer.toString(6));
                    strmDataType.writeUTF(login == null ? "" : login);
                    strmDataType.writeUTF(password == null ? "" : password);
                    strmDataType.writeUTF(oauthToken == null ? "" : oauthToken);
                    strmDataType.writeUTF(oauthTokenSecret == null ? "" : oauthTokenSecret);
                    strmDataType.writeUTF(userId == null ? "" : userId);
                    strmDataType.writeUTF(screenName == null ? "" : screenName);
                    strmDataType.writeUTF(xauthExpires == null ? "" : xauthExpires);
                    byte[] record = strmBytes.toByteArray();
                    if (this.rs_TwitpicUser.getNumRecords() == 0) {
                        this.rs_TwitpicUser.addRecord(record, 0, record.length);
                    } else {
                        this.rs_TwitpicUser.setRecord(1, record, 0, record.length);
                    }
                    strmBytes.reset();
                    strmDataType.flush();
                    result = true;
                }
                catch (RecordStoreException excp) {
                    Log.error("RecordStoreException writing data: " + excp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
                catch (IOException ioExcp) {
                    Log.error("IOException writing data: " + ioExcp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                }
            }
            finally {
                try {
                    strmBytes.close();
                    strmDataType.close();
                }
                catch (IOException ioexcp) {
                    Log.error("IOException closing stream: " + ioexcp.getMessage());
                }
            }
        }
        return result;
    }

    private String read(int dataField) {
        String xAuthExpires;
        String screenName;
        String uesrId;
        String oAuthTokenSecret;
        String oAuthToken;
        String password;
        String login;
        block26: {
            byte[] recData = new byte[255];
            login = "";
            password = "";
            oAuthToken = "";
            oAuthTokenSecret = "";
            uesrId = "";
            screenName = "";
            xAuthExpires = "";
            if (this.rs_TwitpicUser != null) {
                ByteArrayInputStream strmBytes = new ByteArrayInputStream(recData);
                DataInputStream strmDataType = new DataInputStream(strmBytes);
                try {
                    if (this.rs_TwitpicUser.getNumRecords() > 0) {
                        this.rs_TwitpicUser.getRecord(1, recData, 0);
                        login = strmDataType.readUTF();
                        password = strmDataType.readUTF();
                        oAuthToken = strmDataType.readUTF();
                        oAuthTokenSecret = strmDataType.readUTF();
                        uesrId = strmDataType.readUTF();
                        screenName = strmDataType.readUTF();
                        xAuthExpires = strmDataType.readUTF();
                        strmBytes.reset();
                    }
                }
                catch (RecordStoreException excp) {
                    Log.error("RecordStoreException reading data: " + excp.getMessage());
                    try {
                        strmBytes.close();
                        strmDataType.close();
                    }
                    catch (IOException ioexcp) {
                        Log.error("IOException closing stream: " + ioexcp.getMessage());
                    }
                    break block26;
                }
                catch (IOException ioExcp) {
                    try {
                        Log.error("IOException reading data: " + ioExcp.getMessage());
                        break block26;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        try {
                            strmBytes.close();
                            strmDataType.close();
                        }
                        catch (IOException ioexcp) {
                            Log.error("IOException closing stream: " + ioexcp.getMessage());
                        }
                    }
                }
                try {
                    strmBytes.close();
                    strmDataType.close();
                }
                catch (IOException ioexcp) {
                    Log.error("IOException closing stream: " + ioexcp.getMessage());
                }
            }
        }
        switch (dataField) {
            case 0: {
                return login;
            }
            case 1: {
                return password;
            }
            case 2: {
                return oAuthToken;
            }
            case 3: {
                return oAuthTokenSecret;
            }
            case 4: {
                return uesrId;
            }
            case 5: {
                return screenName;
            }
            case 6: {
                return xAuthExpires;
            }
        }
        return null;
    }

    public boolean setAllData(StringMap storeListData) {
        boolean result = false;
        if (storeListData != null) {
            result = this.writeAllData(storeListData);
        }
        return result;
    }

    public String getLogin() {
        String login = "";
        login = this.read(0);
        return login;
    }

    public String getPassword() {
        String password = "";
        password = this.read(1);
        return password;
    }

    public String getOAuthToken() {
        String oAuthToken = "";
        oAuthToken = this.read(2);
        return oAuthToken;
    }

    public String getOAuthTokenSecret() {
        String oAuthTokenSecret = "";
        oAuthTokenSecret = this.read(3);
        return oAuthTokenSecret;
    }

    public String getUserId() {
        String userId = "";
        userId = this.read(4);
        return userId;
    }

    public String getScreenName() {
        String screenName = "";
        screenName = this.read(5);
        return screenName;
    }

    public String getXAuthExpires() {
        String xAuthExpires = "";
        xAuthExpires = this.read(6);
        return xAuthExpires;
    }
}

