/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.codec;

import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Comment;
import com.sonyericsson.webalbum.model.Entry;

public class CommentCodec
extends EntryCodec {
    public static final String ITEM_TYPE = "comment";
    public static final String ATTR_TITLE = ":title";
    public static final String ATTR_TEXT = ":text";
    public static final String ATTR_AUTHOR_NAME = ":author-name";
    public static final String ATTR_AUTHOR_NICKNAME = ":author-nickname";

    public CommentCodec() {
        super(ITEM_TYPE);
    }

    protected Entry createEntry() {
        return new Comment();
    }

    protected void encodeEntry(Entry entry, Attributes attr) {
        super.encodeEntry(entry, attr);
        Comment comment = (Comment)entry;
        Log.trace("CommentCodec.encodeEntry()");
        attr.set("comment:title", AttributeCodec.encodeAttribute(comment.getTitle()));
        attr.set("comment:text", AttributeCodec.encodeAttribute(comment.getText()));
        attr.set("comment:author-name", AttributeCodec.encodeAttribute(comment.getAuthorName()));
        attr.set("comment:author-nickname", AttributeCodec.encodeAttribute(comment.getAuthorNickName()));
        attr.set("content:id", comment.getContentId());
    }

    protected void decodeEntry(Attributes attr, Entry entry) {
        super.decodeEntry(attr, entry);
        Comment comment = (Comment)entry;
        Log.trace("CommentCodec.decodeEntry()");
        comment.setTitle(AttributeCodec.decodeAttribute(attr.get("comment:title")));
        comment.setText(AttributeCodec.decodeAttribute(attr.get("comment:text")));
        comment.setAuthorName(AttributeCodec.decodeAttribute(attr.get("comment:author-name")));
        comment.setAuthorNickName(AttributeCodec.decodeAttribute(attr.get("comment:author-nickname")));
        comment.setContentId(attr.get("content:id"));
    }
}

