/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.log;

import com.sonyericsson.webalbum.log.LogWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class SymbianLogWriter
implements LogWriter {
    private boolean initialized = false;
    private FileConnection fc;
    private OutputStream out;
    private static SymbianLogWriter log = null;

    public static SymbianLogWriter getLog() {
        if (log == null) {
            log = new SymbianLogWriter();
        }
        return log;
    }

    private SymbianLogWriter() {
        try {
            String logName = String.valueOf(SymbianLogWriter.getDateNow()) + "log.txt";
            this.fc = (FileConnection)Connector.open((String)("file:///e:/" + logName), (int)3);
            if (this.fc.exists()) {
                this.fc.delete();
            }
            this.fc.create();
            this.out = this.fc.openOutputStream();
            System.out.println("Log file created");
            this.initialized = true;
            this.write("Log file created.");
            this.write("=== Initializing Application ===");
        }
        catch (Exception e) {
            System.out.println("Error: Cannot create log file");
            e.printStackTrace();
            this.initialized = false;
        }
    }

    public void write(String message) {
        if (this.isEnabled()) {
            try {
                String msg = String.valueOf(SymbianLogWriter.getTimeNow()) + " " + message + "\r\n";
                System.out.println(msg);
                this.out.write(msg.getBytes());
                this.out.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void close() {
        if (this.isEnabled()) {
            try {
                this.write("=== End Application ===");
                this.out.close();
                this.fc.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isEnabled() {
        return this.initialized && this.fc.canWrite();
    }

    private static String getDateNow() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minutes = calendar.get(12);
        return String.valueOf(SymbianLogWriter.intToStr(day)) + SymbianLogWriter.intToStr(month) + Integer.toString(year) + Integer.toString(hour) + Integer.toString(minutes);
    }

    private static String getTimeNow() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        return String.valueOf(SymbianLogWriter.intToStr(hour)) + ":" + SymbianLogWriter.intToStr(min) + ":" + SymbianLogWriter.intToStr(sec);
    }

    private static String intToStr(int value) {
        String retValue = "";
        retValue = value < 10 ? "0" + Integer.toString(value) : Integer.toString(value);
        return retValue;
    }
}

