/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.controller;

import com.sonyericsson.picasaweb.controller.ApplicationListener;
import com.sonyericsson.picasaweb.service.config.Config;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionHandlerMap;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.invocation.InvocationAction;
import com.sonyericsson.webalbum.invocation.InvocationHandler;
import com.sonyericsson.webalbum.invocation.InvocationListener;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.util.CacheUtil;
import javax.microedition.content.Invocation;

public class MainController
implements InvocationListener,
ActionResponseListener {
    private ApplicationListener appListener;
    private InvocationHandler invocHandler;
    private ActionHandlerMap actionHandlerMap;

    public MainController(ApplicationListener appListener, InvocationHandler invocHandler, ActionHandlerMap actionHandlerMap) {
        this.appListener = appListener;
        this.invocHandler = invocHandler;
        this.actionHandlerMap = actionHandlerMap;
        invocHandler.setInvocationListener(this);
    }

    private void initCache(String baseDirUrl) {
        if (CacheUtil.getCacheDirUrl() == null) {
            if (!baseDirUrl.endsWith("/")) {
                baseDirUrl = String.valueOf(baseDirUrl) + "/";
            }
            CacheUtil.setCacheDirUrl(String.valueOf(baseDirUrl) + "cache/");
        }
    }

    public void start() {
        Log.info(this, "Started");
        this.invocHandler.start();
    }

    public void stop() {
        Log.info(this, "Stopped");
        this.invocHandler.stop();
        this.appListener.notifyDestroyed();
    }

    public void inactivityNotify() {
        Log.info(this, "Inactivity reported, stopping");
        CacheUtil.trimCache(Config.getCacheGoalSize());
        this.stop();
    }

    public void invocationRequestNotify(Invocation invocation) {
        InvocationAction action = new InvocationAction(invocation);
        ActionHandler actionHandler = this.actionHandlerMap.getHandler(action.getAction());
        String baseDirUrl = action.getMainData().getUrl();
        if (actionHandler != null && baseDirUrl != null) {
            this.initCache(baseDirUrl);
            try {
                actionHandler.handleAction(action, this);
            }
            catch (Throwable t) {
                Log.warning("MainController caught a " + t.getClass().getName() + ": '" + t.getMessage() + "'");
                this.invocHandler.finishInvocation(invocation, 6);
            }
        } else {
            this.invocHandler.finishInvocation(invocation, 6);
        }
    }

    public void actionCompleteNotify(Action action) {
        this.invocHandler.finishInvocation(((InvocationAction)action).getInvocation(), 5);
    }

    public void actionProgressNotify(Action action) {
        this.invocHandler.reportInvocationProgress(((InvocationAction)action).getInvocation());
    }
}

