/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.Database;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.http.AddAlbumRequest;
import com.sonyericsson.picasaweb.service.http.AddCommentRequest;
import com.sonyericsson.picasaweb.service.http.Authentication;
import com.sonyericsson.picasaweb.service.xml.AlbumParser;
import com.sonyericsson.picasaweb.service.xml.CommentParser;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Album;
import com.sonyericsson.webalbum.model.Comment;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;

public class AddActionHandler
implements ActionHandler {
    private Database database;

    public AddActionHandler(Database database) {
        this.database = database;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAction(Action action, ActionResponseListener responseListener) {
        Attributes outAttr;
        ActionData actionData;
        int result;
        block6: {
            result = 0;
            actionData = action.getMainData();
            Attributes inAttr = actionData.getAttributes();
            outAttr = new Attributes();
            String authToken = this.database.getAuthUser().getAuthToken();
            Log.trace("AddActionHandler#handleAction");
            try {
                Entry addedEntry;
                void var8_11;
                if (authToken == null) {
                    throw new ServiceException(5);
                }
                Object var8_8 = null;
                Entry entry = EntryCodec.decodeEntry(inAttr);
                EntryParser parser = null;
                if (entry instanceof Album) {
                    Album album = (Album)entry;
                    if (album.getTitle() == null) throw new ServiceException(4);
                    parser = new AlbumParser(0, 1, "/entry");
                    AddAlbumRequest addAlbumRequest = new AddAlbumRequest(Authentication.createHeaders(authToken), album, (AlbumParser)parser);
                } else {
                    if (!(entry instanceof Comment)) throw new ServiceException(2);
                    Comment comment = (Comment)entry;
                    if (comment.getContentId() == null || comment.getText() == null) throw new ServiceException(4);
                    parser = new CommentParser(0, 1, "/entry");
                    AddCommentRequest addCommentRequest = new AddCommentRequest(Authentication.createHeaders(authToken), comment, (CommentParser)parser);
                }
                Log.trace("AddActionHandler#handleAction: Making HTTP request to add entry");
                ActionUtil.doHttpRequest((HttpRequest)var8_11);
                if (parser != null && (addedEntry = parser.getFirstEntry()) != null) {
                    outAttr = EntryCodec.encodeEntry(addedEntry);
                }
            }
            catch (ServiceException serviceException) {
                result = serviceException.getResult();
                if (result != 5) break block6;
                this.database.setAuthUser(null);
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

