/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.http.Authentication;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.DownloadItem;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.TransferItem;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.DownloadRequest;
import com.sonyericsson.webalbum.service.transfer.TransferJob;
import com.sonyericsson.webalbum.service.transfer.TransferRequestProgressListener;
import com.sonyericsson.webalbum.util.CacheUtil;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.file.FileConnection;

public class DownloadJob
extends TransferJob
implements TransferRequestProgressListener {
    private static final int DOWNLOAD_PROGRESS_INTERVAL = 10240;
    private String authToken;

    public DownloadJob(int id, DownloadItem[] items, String authToken) {
        super(id, items);
        this.authToken = authToken;
    }

    private int downloadFile(String url, String localUrl) {
        int result;
        block16: {
            result = 0;
            DownloadItem item = (DownloadItem)this.getCurrentItem();
            FileConnection fc = null;
            OutputStream os = null;
            Log.trace("DownloadJob#downloadFile: Downloading from " + url + " to " + localUrl);
            try {
                try {
                    fc = CacheUtil.createCachedFile(localUrl);
                    os = fc.openOutputStream();
                    this.currentRequest = new DownloadRequest(url, Authentication.createHeaders(this.authToken), os);
                    this.currentRequest.setTransferRequestProgressListener(this, 10240);
                    try {
                        if (this.cancelled) {
                            this.currentRequest.cancel();
                        } else {
                            Log.trace("DownloadJob#downloadFile: Making request");
                            ActionUtil.doHttpRequest(this.currentRequest);
                            Log.trace("DownloadJob#downloadFile: Request complete");
                        }
                        if (!this.currentRequest.isCancelled()) {
                            Log.trace("DownloadJob#downloadFile: Marking cached file as valid");
                            CacheUtil.markCachedFileAsValid(localUrl);
                            item.setState(5);
                        }
                    }
                    catch (ServiceException e) {
                        item.setState(4);
                        Log.logException(e);
                    }
                }
                catch (IOException e) {
                    item.setState(4);
                    Log.logException(e);
                    IOUtil.closeOutputStream(os);
                    IOUtil.closeConnection((Connection)fc);
                    if (this.currentRequest != null) {
                        item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                        if (this.currentRequest.isCancelled()) {
                            item.setState(3);
                            result = 1;
                        }
                        this.currentRequest = null;
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeOutputStream(os);
                IOUtil.closeConnection((Connection)fc);
                if (this.currentRequest != null) {
                    item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                    item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                    if (this.currentRequest.isCancelled()) {
                        item.setState(3);
                        result = 1;
                    }
                    this.currentRequest = null;
                }
                throw throwable;
            }
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection((Connection)fc);
            if (this.currentRequest != null) {
                item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
                item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
                if (this.currentRequest.isCancelled()) {
                    item.setState(3);
                    result = 1;
                }
                this.currentRequest = null;
            }
        }
        return result;
    }

    protected int transferCurrentItem() {
        DownloadItem item = (DownloadItem)this.getCurrentItem();
        Resource resource = item.getResource();
        String url = resource.getUrl();
        String localUrl = resource.getLocalUrl();
        item.setState(2);
        this.reportProgress();
        return this.downloadFile(url, localUrl);
    }

    public void requestProgressNotify() {
        TransferItem item = this.getCurrentItem();
        item.setTotalNrBytes(this.currentRequest.getResponseContentLength());
        item.setCurrentNrBytes(this.currentRequest.getNrTransferredBytes());
        this.reportProgress();
    }
}

