/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.Database;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;

public class GetActionHandler
implements ActionHandler {
    private Database database;

    public GetActionHandler(Database database) {
        this.database = database;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = null;
        String baseDir = actionData.getUrl();
        String authToken = this.database.getAuthUser().getAuthToken();
        try {
            if (baseDir == null) {
                throw new ServiceException(4);
            }
            Entry entry = ActionUtil.fetchEntry(authToken, inAttr);
            outAttr = EntryCodec.encodeEntry(entry);
        }
        catch (ServiceException se) {
            result = se.getResult();
            if (result == 5) {
                this.database.setAuthUser(null);
            }
            outAttr = new Attributes();
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

