/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.Database;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.AttributeCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class InfoActionHandler
implements ActionHandler {
    private static final String ATTR_USER_NAME = "user:name";
    private static final String ATTR_USER_NICKNAME = "user:nickname";
    private static final String ATTR_AUTH_SIGN_UP_URL = "auth:sign-up-url";
    private static final String ATTR_AUTH_ENABLED = "auth:enabled";
    private static final String ATTR_VIDEO_MAX_SIZE = "video:max-size";
    private static final String ATTR_VIDEO_MAX_LENGTH = "video:max-length";
    private static final String LOG_PREFIX = "InfoActionHandler: ";
    private Database database;

    public InfoActionHandler(Database database) {
        this.database = database;
    }

    private String copyIcon(String baseDir) throws ServiceException {
        String url = baseDir;
        FileConnection fc = null;
        InputStream is = null;
        OutputStream os = null;
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + "icon.png";
        Log.trace("InfoActionHandler: copying icon to " + url);
        try {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (!fc.exists()) {
                    Log.trace("InfoActionHandler: creating icon file");
                    fc.create();
                }
                Log.trace("InfoActionHandler: opening streams");
                os = fc.openOutputStream();
                Log.trace("InfoActionHandler: created os " + os);
                is = this.getClass().getResourceAsStream("/icon.png");
                Log.trace("InfoActionHandler: created is " + is);
                int nrBytes = IOUtil.copyStream(is, os);
                Log.trace("InfoActionHandler: data written: " + nrBytes + " bytes");
            }
            catch (IOException e) {
                Log.logException(e);
                throw new ServiceException(9);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeInputStream(is);
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection((Connection)fc);
            throw throwable;
        }
        IOUtil.closeInputStream(is);
        IOUtil.closeOutputStream(os);
        IOUtil.closeConnection((Connection)fc);
        return url;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes outAttr = new Attributes();
        String baseDir = actionData.getUrl();
        try {
            if (baseDir != null && baseDir.startsWith("file://")) {
                String iconUrl = this.copyIcon(baseDir);
                actionData.setUrl(iconUrl);
            }
        }
        catch (ServiceException se) {
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        outAttr.set(ATTR_AUTH_ENABLED, "true");
        outAttr.set(ATTR_AUTH_SIGN_UP_URL, AttributeCodec.encodeAttribute("https://www.google.com/accounts/NewAccount"));
        outAttr.set(ATTR_USER_NICKNAME, AttributeCodec.encodeAttribute(this.database.getAuthUser().getNickname()));
        outAttr.set(ATTR_USER_NAME, AttributeCodec.encodeAttribute(this.database.getAuthUser().getName()));
        outAttr.set(ATTR_VIDEO_MAX_SIZE, String.valueOf(0x6400000));
        outAttr.set(ATTR_VIDEO_MAX_LENGTH, String.valueOf(3600));
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

