/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.service.Database;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.http.Authentication;
import com.sonyericsson.picasaweb.service.http.UrlFactory;
import com.sonyericsson.picasaweb.service.xml.AlbumParser;
import com.sonyericsson.picasaweb.service.xml.CommentParser;
import com.sonyericsson.picasaweb.service.xml.ContentParser;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.EntryList;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.DownloadRequest;
import com.sonyericsson.webalbum.util.CacheUtil;
import com.sonyericsson.webalbum.util.IOUtil;
import com.sonyericsson.webalbum.xml.XmlException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class ListActionHandler
implements ActionHandler {
    private static final String ATTR_LIST_START_ENTRY = "list:start-entry";
    private static final String ATTR_LIST_END_ENTRY = "list:end-entry";
    private static final String ATTR_LIST_FORCE_REFRESH = "list:force-refresh";
    private Database database;

    public ListActionHandler(Database database) {
        this.database = database;
    }

    private EntryList getEntryList(ActionData actionData) throws ServiceException {
        EntryList list;
        int endIndex;
        int startIndex;
        Attributes inAttr = actionData.getAttributes();
        String authToken = this.database.getAuthUser().getAuthToken();
        String requestUrl = null;
        String localUrl = null;
        EntryParser entryParser = null;
        try {
            startIndex = Integer.parseInt(inAttr.get(ATTR_LIST_START_ENTRY));
            endIndex = Integer.parseInt(inAttr.get(ATTR_LIST_END_ENTRY));
        }
        catch (NumberFormatException e) {
            startIndex = 0;
            endIndex = Integer.MAX_VALUE;
        }
        String type = inAttr.get("item:type");
        if (type == null) {
            throw new ServiceException(4);
        }
        if (type.equals("album")) {
            requestUrl = UrlFactory.createListAlbumsUrl();
            entryParser = new AlbumParser(startIndex, endIndex, "/feed/entry");
        } else if (type.equals("content")) {
            String albumId = inAttr.get("album:id");
            String mediumFilter = inAttr.get("content:medium");
            if (albumId == null) {
                throw new ServiceException(4);
            }
            requestUrl = UrlFactory.createListContentUrl(albumId);
            entryParser = new ContentParser(startIndex, endIndex, "/feed/entry", mediumFilter);
        } else if (type.equals("comment")) {
            String contentId = inAttr.get("content:id");
            if (contentId == null) {
                throw new ServiceException(4);
            }
            requestUrl = UrlFactory.createListCommentsUrl(contentId);
            entryParser = new CommentParser(startIndex, endIndex, "/feed/entry");
        } else {
            throw new ServiceException(3);
        }
        if (requestUrl == null || entryParser == null) {
            throw new ServiceException(12);
        }
        localUrl = CacheUtil.getCachedFileUrl(requestUrl);
        boolean doDownload = this.downloadNeeded(localUrl, inAttr.get(ATTR_LIST_FORCE_REFRESH));
        if (doDownload) {
            this.downloadFeed(requestUrl, authToken, localUrl);
        }
        try {
            list = this.parseFeed(localUrl, entryParser);
        }
        catch (ServiceException se) {
            if (doDownload) {
                throw se;
            }
            Log.info("ListActionHandler: Could not parse cached feed, refreshing it");
            this.downloadFeed(requestUrl, authToken, localUrl);
            list = this.parseFeed(localUrl, entryParser);
        }
        return list;
    }

    private boolean downloadNeeded(String localUrl, String forceRefresh) {
        boolean downloadNeeded = false;
        if (forceRefresh != null && forceRefresh.toLowerCase().equals("true")) {
            downloadNeeded = true;
        } else if (!CacheUtil.cachedFileIsValid(localUrl)) {
            downloadNeeded = true;
        }
        return downloadNeeded;
    }

    private EntryList parseFeed(String localUrl, EntryParser entryParser) throws ServiceException {
        EntryList list = null;
        FileConnection fc = null;
        InputStream is = null;
        try {
            try {
                fc = (FileConnection)Connector.open((String)localUrl);
                is = fc.openInputStream();
                CacheUtil.markCachedFileAsUsed(localUrl);
                try {
                    entryParser.parse(is);
                    list = entryParser.getEntries();
                }
                catch (XmlException e) {
                    Log.logException(e);
                }
            }
            catch (IOException e) {
                throw new ServiceException(9);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeConnection(fc);
            throw throwable;
        }
        IOUtil.closeConnection((Connection)fc);
        if (list == null) {
            throw new ServiceException(12);
        }
        return list;
    }

    private void downloadFeed(String requestUrl, String authToken, String localUrl) throws ServiceException {
        FileConnection fc = null;
        OutputStream os = null;
        if (authToken == null) {
            throw new ServiceException(5);
        }
        try {
            try {
                fc = CacheUtil.createCachedFile(localUrl);
                os = fc.openOutputStream();
                DownloadRequest dr = new DownloadRequest(requestUrl, Authentication.createHeaders(authToken), os);
                ActionUtil.doHttpRequest(dr);
                CacheUtil.markCachedFileAsValid(localUrl);
            }
            catch (IOException e) {
                if (fc != null && fc.availableSize() < 1000L) {
                    throw new ServiceException(10);
                }
                throw new ServiceException(9);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection((Connection)fc);
            throw throwable;
        }
        IOUtil.closeOutputStream(os);
        IOUtil.closeConnection((Connection)fc);
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        Attributes outAttr;
        ActionData actionData;
        int result;
        block3: {
            result = 0;
            actionData = action.getMainData();
            outAttr = new Attributes();
            try {
                EntryList list = this.getEntryList(actionData);
                outAttr.set("list:entry-count", String.valueOf(list.getTotalNrOfEntries()));
                outAttr.set(ATTR_LIST_START_ENTRY, String.valueOf(list.getStartIndex()));
                outAttr.set(ATTR_LIST_END_ENTRY, String.valueOf(list.getEndIndex()));
                Log.trace("Got " + list.getTotalNrOfEntries() + " entries");
                int i = list.getStartIndex();
                while (i < list.getEndIndex()) {
                    Entry entry = list.getEntry(i);
                    ActionData childData = action.addChildData();
                    Log.trace("Encoding entry " + i);
                    Attributes partOutAttr = EntryCodec.encodeEntry(entry);
                    childData.setAttributes(partOutAttr);
                    ++i;
                }
            }
            catch (ServiceException se) {
                result = se.getResult();
                if (result != 5) break block3;
                this.database.setAuthUser(null);
            }
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

