/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.model.PicasaUploadItem;
import com.sonyericsson.picasaweb.service.Database;
import com.sonyericsson.picasaweb.service.action.UploadJob;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.codec.EntryCodec;
import com.sonyericsson.webalbum.job.JobManager;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.model.UploadItem;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import com.sonyericsson.webalbum.service.transfer.UploadJobResponseHandler;

public class UploadActionHandler
implements ActionHandler {
    private Database database;
    private JobManager jobManager;

    public UploadActionHandler(Database database, JobManager jobManager) {
        this.database = database;
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData mainData = action.getMainData();
        Attributes mainInAttr = mainData.getAttributes();
        String baseDir = mainData.getUrl();
        String authToken = this.database.getAuthUser().getAuthToken();
        String disableDownscalingString = null;
        boolean disableDownscaling = false;
        try {
            int transferId = 0;
            int count = action.getChildDataCount();
            UploadItem[] items = new PicasaUploadItem[count];
            if (baseDir == null) {
                throw new ServiceException(4);
            }
            if (authToken == null) {
                throw new ServiceException(5);
            }
            try {
                transferId = Integer.parseInt(mainInAttr.get("transfer:id"));
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            int i = 0;
            while (i < count) {
                ActionData childData = action.getChildData(i);
                Attributes childAttr = childData.getAttributes();
                disableDownscalingString = childAttr.get("content:disable-downscaling");
                if (disableDownscalingString != null && disableDownscalingString.equalsIgnoreCase("true")) {
                    disableDownscaling = true;
                }
                Entry entry = EntryCodec.decodeEntry(childData.getAttributes());
                String localUrl = childData.getUrl();
                items[i] = new PicasaUploadItem(entry, disableDownscaling);
                if (entry instanceof Content && localUrl != null) {
                    Resource resource = new Resource("content");
                    resource.setLocalUrl(localUrl);
                    entry.addResource(resource);
                    items[i].setState(1);
                } else {
                    items[i].setState(4);
                }
                ++i;
            }
            UploadJob uj = new UploadJob(transferId, items, authToken, baseDir);
            uj.setTransferJobListener(new UploadJobResponseHandler(action, responseListener));
            this.jobManager.addJob(uj);
        }
        catch (ServiceException se) {
            int result = se.getResult();
            Attributes outAttr = new Attributes();
            outAttr.set("result", Result.toString(result), 0);
            mainData.setAttributes(outAttr);
            responseListener.actionCompleteNotify(action);
        }
    }
}

