/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.http;

import com.sonyericsson.webalbum.http.HttpRequest;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.xml.XmlEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public class UpdateContentRequest
extends HttpRequest {
    private Content content;

    public UpdateContentRequest(String editUrl, Hashtable headers, Content content) {
        super("POST", editUrl, headers);
        this.content = content;
        headers.put("X-HTTP-Method-Override", "PUT");
        headers.put("Content-Type", "application/atom+xml");
    }

    private void writeAtomEntry(OutputStream os) throws IOException {
        XmlEncoder enc = new XmlEncoder(os);
        enc.startElement("entry", "xmlns='http://www.w3.org/2005/Atom'");
        enc.addElement("title", null, this.getContentTitle());
        enc.addElement("summary", null, this.content.getDescription());
        enc.addElement("category", "scheme=\"http://schemas.google.com/g/2005#kind\" term=\"http://schemas.google.com/photos/2007#photo\"");
        enc.endElement();
        enc.flush();
    }

    private String getContentTitle() {
        int lastSlashPos;
        String localUrl;
        Resource resource;
        String title = this.content.getTitle();
        if (title == null && (resource = this.content.getResource("content")) != null && (localUrl = resource.getLocalUrl()) != null && (lastSlashPos = localUrl.lastIndexOf(47)) >= 0) {
            title = localUrl.substring(lastSlashPos + 1);
        }
        if (title == null) {
            title = "unknown";
        }
        return title;
    }

    public void writeBody(OutputStream os) throws IOException {
        this.writeAtomEntry(os);
    }
}

