/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.xml;

import com.sonyericsson.picasaweb.service.util.EntryUtil;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.webalbum.model.Content;
import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.ImageResource;
import com.sonyericsson.webalbum.model.Resource;
import com.sonyericsson.webalbum.util.MimeUtil;
import org.xml.sax.Attributes;

public class ContentParser
extends EntryParser {
    private String mediumFilter;

    public ContentParser(int startIndex, int endIndex, String entryPath, String mediumFilter) {
        super(startIndex, endIndex, entryPath);
        this.mediumFilter = mediumFilter;
    }

    public void startElement(String element, Attributes attributes) {
        super.startElement(element, attributes);
        if (this.currentEntry != null) {
            if (this.isCurrentPath(String.valueOf(this.entryPath) + "/media:group/media:thumbnail")) {
                String url = attributes.getValue("url");
                String width = attributes.getValue("width");
                String height = attributes.getValue("height");
                ImageResource resource = new ImageResource("thumbnail", url, MimeUtil.getContentTypeFromUrl(url), Integer.parseInt(width), Integer.parseInt(height));
                this.currentEntry.addResource(resource);
            } else if (this.isCurrentPath(String.valueOf(this.entryPath) + "/media:group/media:content")) {
                String url = attributes.getValue("url");
                String medium = attributes.getValue("medium");
                String contentType = attributes.getValue("type");
                int width = this.parseInt(attributes.getValue("width"));
                int height = this.parseInt(attributes.getValue("height"));
                if (!"video".equals(((Content)this.currentEntry).getMedium())) {
                    Resource resource = "image".equals(medium) && height > 0 && width > 0 ? new ImageResource("content", url, contentType, width, height) : new Resource("content", url, contentType);
                    this.currentEntry.addResource(resource);
                    ((Content)this.currentEntry).setMedium(medium);
                }
            }
        }
    }

    public void characters(String element, char[] ch, int start, int length) {
        super.characters(element, ch, start, length);
        if (this.currentEntry != null) {
            if (this.isCurrentPath(String.valueOf(this.entryPath) + "/title")) {
                ((Content)this.currentEntry).setTitle(new String(ch, start, length));
            } else if (this.isCurrentPath(String.valueOf(this.entryPath) + "/summary")) {
                ((Content)this.currentEntry).setDescription(new String(ch, start, length));
            }
        }
    }

    protected Entry createEntry() {
        return new Content();
    }

    protected String getEntryId(String urlPart) {
        return EntryUtil.encodeContentId(urlPart);
    }

    protected boolean entryIsValid(Entry entry) {
        return this.mediumFilter == null || this.mediumFilter.equals(((Content)entry).getMedium());
    }

    protected void handleRssUrl(String url) {
        int pos = url.indexOf("/photoid/");
        if (pos >= 0) {
            url = url.substring(0, pos);
        }
        super.handleRssUrl(url);
    }
}

