/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.xml;

import com.sonyericsson.webalbum.model.Entry;
import com.sonyericsson.webalbum.model.EntryList;
import com.sonyericsson.webalbum.xml.XmlParser;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import org.xml.sax.Attributes;

public abstract class EntryParser
extends XmlParser {
    private static final String QUERYSTRING_PART_AUTHKEY = "authkey=";
    private static final String QUERYSTRING_PART_ALT_RSS = "alt=rss";
    private static final String VALUE_FEED_SCHEMA = "http://schemas.google.com/g/2005#feed";
    private static final String VALUE_EDIT = "edit";
    private static final String VALUE_ALTERNATE = "alternate";
    private static final String ATTRIBUTE_HREF = "href";
    private static final String ATTRIBUTE_REL = "rel";
    private static final String ELEMENT_ENTRY = "entry";
    public static final String ENTRY_PATH_ENTRY = "/entry";
    public static final String ENTRY_PATH_FEED = "/feed/entry";
    protected String entryPath;
    private Vector entries = new Vector();
    private int nrOfEntries;
    private int startIndex;
    private int endIndex;
    protected Entry currentEntry;

    protected EntryParser(int startIndex, int endIndex, String entryPath) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.entryPath = entryPath;
    }

    protected abstract Entry createEntry();

    protected abstract String getEntryId(String var1);

    protected int parseInt(String s) {
        int i = 0;
        try {
            i = Integer.parseInt(s);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return i;
    }

    public EntryList getEntries() {
        return new EntryList(this.nrOfEntries, this.startIndex, this.entries);
    }

    public Entry getFirstEntry() {
        Entry entry = null;
        if (this.entries.size() > 0) {
            entry = (Entry)this.entries.firstElement();
        }
        return entry;
    }

    public void startElement(String element, Attributes attributes) {
        if (element.equals(ELEMENT_ENTRY)) {
            this.currentEntry = this.createEntry();
        }
        if (this.currentEntry != null && this.isCurrentPath(String.valueOf(this.entryPath) + "/link")) {
            String rel = attributes.getValue(ATTRIBUTE_REL);
            String href = attributes.getValue(ATTRIBUTE_HREF);
            if (rel != null && href != null) {
                if (rel.equals(VALUE_EDIT)) {
                    this.handleEditUrl(href);
                } else if (rel.equals(VALUE_ALTERNATE) && this.urlIsPublic(href)) {
                    this.handleWebPageUrl(href);
                } else if (rel.equals(VALUE_FEED_SCHEMA) && this.urlIsPublic(href)) {
                    this.handleRssUrl(href);
                }
            }
        }
    }

    protected void characters(String element, char[] ch, int start, int length) {
        if (this.currentEntry != null) {
            if (this.isCurrentPath(String.valueOf(this.entryPath) + "/id")) {
                String url = new String(ch, start, length);
                int idPos = url.indexOf("/albumid/");
                if (idPos >= 0) {
                    this.currentEntry.setId(this.getEntryId(url.substring(idPos)));
                }
            } else if (this.isCurrentPath(String.valueOf(this.entryPath) + "/published")) {
                String isoTime = new String(ch, start, length);
                long timestamp = this.decodeTimestamp(isoTime);
                this.currentEntry.setTimestamp(timestamp);
            }
        }
    }

    private long decodeTimestamp(String isoTime) {
        long timestamp = 0L;
        try {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            calendar.set(1, Integer.parseInt(isoTime.substring(0, 4)));
            calendar.set(2, Integer.parseInt(isoTime.substring(5, 7)) - 1);
            calendar.set(5, Integer.parseInt(isoTime.substring(8, 10)));
            calendar.set(11, Integer.parseInt(isoTime.substring(11, 13)));
            calendar.set(12, Integer.parseInt(isoTime.substring(14, 16)));
            calendar.set(13, Integer.parseInt(isoTime.substring(17, 19)));
            calendar.set(14, 0);
            timestamp = calendar.getTime().getTime();
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return timestamp;
    }

    public final void endElement(String element) {
        if (this.currentEntry != null && element.equals(ELEMENT_ENTRY)) {
            if (this.entryIsValid(this.currentEntry)) {
                if (this.nrOfEntries >= this.startIndex && this.nrOfEntries < this.endIndex) {
                    this.entries.addElement(this.currentEntry);
                }
                ++this.nrOfEntries;
            }
            this.currentEntry = null;
        }
    }

    protected boolean entryIsValid(Entry entry) {
        return true;
    }

    protected void handleEditUrl(String url) {
        this.currentEntry.setEditUrl(url);
    }

    protected void handleWebPageUrl(String url) {
        this.currentEntry.setWebPageUrl(url);
    }

    protected void handleRssUrl(String url) {
        int queryStringPos = url.indexOf("?");
        url = queryStringPos >= 0 ? String.valueOf(url) + "&" : String.valueOf(url) + "?";
        url = String.valueOf(url) + QUERYSTRING_PART_ALT_RSS;
        this.currentEntry.setRssUrl(url);
    }

    private boolean urlIsPublic(String url) {
        return url.indexOf(QUERYSTRING_PART_AUTHKEY) < 0;
    }
}

