/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.test;

import com.sonyericsson.picasaweb.test.FakeHttpConnectionFactory;
import com.sonyericsson.webalbum.action.Action;
import com.sonyericsson.webalbum.action.ActionData;
import com.sonyericsson.webalbum.action.ActionHandler;
import com.sonyericsson.webalbum.action.ActionResponseListener;
import com.sonyericsson.webalbum.action.Attributes;
import com.sonyericsson.webalbum.http.DefaultConnectionFactory;
import com.sonyericsson.webalbum.http.HttpUtil;
import com.sonyericsson.webalbum.log.ConsoleLogWriter;
import com.sonyericsson.webalbum.log.DisplayLogWriter;
import com.sonyericsson.webalbum.log.FileLogWriter;
import com.sonyericsson.webalbum.log.Log;
import com.sonyericsson.webalbum.service.Result;
import com.sonyericsson.webalbum.service.ServiceException;
import java.io.IOException;

public class DebugActionHandler
implements ActionHandler {
    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = new Attributes();
        String url = actionData.getUrl();
        try {
            String logOutput = inAttr.get("debug:log-output");
            if ("console".equals(logOutput)) {
                Log.setWriter(new ConsoleLogWriter());
            } else if ("display".equals(logOutput)) {
                Log.setWriter(new DisplayLogWriter());
            } else if ("file".equals(logOutput)) {
                try {
                    if (!url.endsWith("/")) {
                        url = String.valueOf(url) + "/";
                    }
                    url = String.valueOf(url) + "log.txt";
                    Log.setWriter(new FileLogWriter(url));
                }
                catch (IOException e) {
                    throw new ServiceException(9);
                }
            }
            String fakeHttp = inAttr.get("debug:fake-http");
            if ("on".equals(fakeHttp)) {
                HttpUtil.setConnectionFactory(new FakeHttpConnectionFactory());
            } else if ("off".equals(fakeHttp)) {
                HttpUtil.setConnectionFactory(new DefaultConnectionFactory());
            }
        }
        catch (ServiceException se) {
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

