/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.test;

import com.sonyericsson.webalbum.log.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.io.file.FileConnection;

public class FakeHttpConnection
implements HttpConnection {
    private String url;
    private String requestMethod;
    private FileConnection inputFc;
    private String inputUrl;
    private FileConnection outputFc;
    private String outputUrl;
    private int responseCode = 200;
    private String responseMessage = "OK";

    public FakeHttpConnection(String url) {
        this.url = url;
    }

    private void init() throws IOException {
        if (this.inputUrl == null) {
            String statusUrl;
            FileConnection statusFc;
            Log.trace("FakeHttpConnection#init: Faking url " + this.url);
            this.inputUrl = "file:///c:/system/http/" + this.url.substring(7);
            int queryStringPos = this.inputUrl.indexOf("?");
            if (queryStringPos >= 0) {
                this.inputUrl = this.inputUrl.substring(0, queryStringPos);
            }
            this.inputFc = (FileConnection)Connector.open((String)this.inputUrl);
            if (!this.inputFc.exists()) {
                Log.trace("Fake URL does not exist!");
                throw new IOException("Invalid URL");
            }
            if (this.inputFc.isDirectory()) {
                this.inputFc.close();
                this.inputUrl = String.valueOf(this.inputUrl) + "/" + this.requestMethod.toLowerCase();
                this.inputFc = (FileConnection)Connector.open((String)this.inputUrl);
            }
            Log.trace("FakeHttpConnection#init: fake inputUrl = " + this.inputUrl);
            if (this.requestMethod.equals("POST")) {
                this.outputUrl = String.valueOf(this.inputUrl) + ".posted" + System.currentTimeMillis();
                this.outputFc = (FileConnection)Connector.open((String)this.outputUrl);
                if (!this.outputFc.exists()) {
                    this.outputFc.create();
                }
                Log.trace("FakeHttpConnection#init: fake outputUrl = " + this.outputUrl);
            }
            if ((statusFc = (FileConnection)Connector.open((String)(statusUrl = String.valueOf(this.inputUrl) + ".status"))).exists()) {
                InputStream is = statusFc.openInputStream();
                byte[] bytes = new byte[100];
                int nrBytes = is.read(bytes);
                String status = new String(bytes, 0, nrBytes);
                this.responseCode = Integer.parseInt(status.substring(0, 3));
                this.responseMessage = status.substring(4);
                is.close();
            }
            statusFc.close();
        }
    }

    public long getDate() throws IOException {
        return 0L;
    }

    public long getExpiration() throws IOException {
        return 0L;
    }

    public String getFile() {
        return null;
    }

    public String getHeaderField(String header) throws IOException {
        this.init();
        if (header.equals("Content-Length")) {
            return String.valueOf(this.inputFc.fileSize());
        }
        return null;
    }

    public String getHeaderField(int arg0) throws IOException {
        return null;
    }

    public long getHeaderFieldDate(String arg0, long arg1) throws IOException {
        return 0L;
    }

    public int getHeaderFieldInt(String arg0, int arg1) throws IOException {
        return 0;
    }

    public String getHeaderFieldKey(int arg0) throws IOException {
        return null;
    }

    public String getHost() {
        return null;
    }

    public long getLastModified() throws IOException {
        return 0L;
    }

    public int getPort() {
        return 0;
    }

    public String getProtocol() {
        return null;
    }

    public String getQuery() {
        return null;
    }

    public String getRef() {
        return null;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestProperty(String arg0) {
        return null;
    }

    public int getResponseCode() throws IOException {
        this.init();
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        this.init();
        return this.responseMessage;
    }

    public String getURL() {
        return this.url;
    }

    public void setRequestMethod(String requestMethod) throws IOException {
        this.requestMethod = requestMethod;
    }

    public void setRequestProperty(String arg0, String arg1) throws IOException {
    }

    public String getEncoding() {
        return null;
    }

    public long getLength() {
        return 0L;
    }

    public String getType() {
        return null;
    }

    public DataInputStream openDataInputStream() throws IOException {
        this.init();
        Log.trace("FakeHttpConnection#openDataInputStream: opening DataInputStream");
        return this.inputFc.openDataInputStream();
    }

    public InputStream openInputStream() throws IOException {
        this.init();
        Log.trace("FakeHttpConnection#openInputStream: opening InputStream");
        return this.inputFc.openInputStream();
    }

    public void close() throws IOException {
        if (this.inputFc != null) {
            this.inputFc.close();
            this.inputFc = null;
        }
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        this.init();
        DataOutputStream dos = null;
        if (this.outputFc != null) {
            Log.trace("FakeHttpConnection#openDataOutputStream: opening DataOutputStream");
            dos = this.outputFc.openDataOutputStream();
        }
        return dos;
    }

    public OutputStream openOutputStream() throws IOException {
        this.init();
        OutputStream os = null;
        if (this.outputFc != null) {
            Log.trace("FakeHttpConnection#openOutputStream: opening OutputStream");
            os = this.outputFc.openOutputStream();
        }
        return os;
    }
}

