/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.webalbum.http;

import com.sonyericsson.webalbum.log.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public abstract class HttpRequest {
    private String method;
    private String url;
    private Hashtable headers;
    private int responseCode;
    private String responseMessage;
    private int contentLength;

    protected HttpRequest(String method, String url) {
        this(method, url, null);
    }

    protected HttpRequest(String method, String url, Hashtable headers) {
        this.method = method;
        this.url = url;
        this.headers = headers != null ? headers : new Hashtable();
    }

    final String getMethod() {
        return this.method;
    }

    final String getURL() {
        return this.url;
    }

    public final Hashtable getHeaders() {
        return this.headers;
    }

    final void setResponse(int responseCode, String responseMessage) {
        this.responseCode = responseCode;
        this.responseMessage = responseMessage;
        Log.trace("Http Response: " + responseCode + " (" + responseMessage + ")");
    }

    final void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    protected final void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public void writeBody(OutputStream os) throws IOException {
    }

    public final int getResponseCode() {
        return this.responseCode;
    }

    public final String getResponseMessage() {
        return this.responseMessage;
    }

    public final int getResponseContentLength() {
        return this.contentLength;
    }

    public void readResponseBody(InputStream is) throws IOException {
    }
}

