function doSearch() {
    document.getElementById('search').submit();
}

function doGo() {
    var address = document.getElementById('address').value;
    location.href = "http://" + address;
    location.replace;
}

function switchBackground(elementId, state) {
	var element = document.getElementById(elementId);
	
	if (elementId == 'googleButtonImage') {
		if (state == "selected") {
			element.src = "../images/google-button-image-selected.png";
		}
		else if (state == "unselected") {
			element.src = "../images/google-button-image.png";
		}
	}
	else if (elementId == 'goButtonImage') {
		if (state == "selected") {
			element.src = "../images/go-button-image-selected.png";
		}
		else if (state == "unselected") {
			element.src = "../images/go-button-image.png";
		}
	}
}

function focusInputSearch(o) {
    o.value = "";
	switchInputLayout("selected", "google");
}

function blurInputSearch(o) {
    if (o.value == "")
        o.value = OLP_SEARCH_TXT;
	
	switchInputLayout("selected", "google");
}

function focusInputGo(o) {
    o.value = "";
	switchInputLayout("selected", "go");
}

function blurInputGo(o) {
    if (o.value == "")
        o.value = OLP_ENTERADDRESS_TXT;
		
	switchInputLayout("selected", "go");
}

function switchInputLayout(state, input) {
	var leftFrame = document.getElementById('searchLeftFrame');
	var rightFrame = document.getElementById('searchRightFrame');
	var contentFrame = document.getElementById('searchContent');
	
	if (state == "selected") {
		leftFrame.style.backgroundImage = "url(../images/left-inputs.png)";
		rightFrame.style.backgroundImage = "url(../images/right-inputs.png)";
		contentFrame.style.backgroundImage = "url(../images/content-inputs.png)";
	}
	else if (state == "unselected") {
		leftFrame.style.backgroundImage = "url(../images/left-inputs.png)";
		rightFrame.style.backgroundImage = "url(../images/right-inputs.png)";
		contentFrame.style.backgroundImage = "url(../images/content-inputs.png)";
	}
}

function switchButtonLayout(state, input, action) {
	var leftFrame = document.getElementById('leftFrame');
	var rightFrame = document.getElementById('rightFrame');
	var contentFrame = document.getElementById('buttonsContainer');
	
	resetButtonLayout();
	
	if (state == "selected") {
		
		leftFrame.style.backgroundImage = "url(../images/left-frame-" + input + "-selected.png)";
		rightFrame.style.backgroundImage = "url(../images/right-frame-" + input + "-selected.png)";
		contentFrame.style.backgroundImage = "url(../images/bottom-content-" + input + "-selected.png)";
	}
	
	setIconLayout(state, action);
	
	setTimeout(function () { redirectToAction(action); }, 700);
}

function redirectToAction(action) {
	if (action == "play-now") {
		window.location = "subscriberinfo:lang,plmn,cplmn,model?url=http://wap.sonyericsson.com/download/download.do?cmd=owp&appl=home";
	}
	else if (action == "accessories") {
		window.location = "subscriberinfo:lang,plmn,cplmn,model?url=http://wap.sonyericsson.com/download/download.do?cmd=owp&appl=accessories";
	}
	else if (action == "sehome") {
		window.location = "subscriberinfo:lang,plmn,cplmn,model?url=http://wap.sonyericsson.com/download/download.do?cmd=owp&appl=sehome";
	}
	else if (action == "support") {
		window.location = "subscriberinfo:lang,plmn,cplmn,model?url=http://wap.sonyericsson.com/download/download.do?cmd=owp&appl=contactus";
	}
}

function resetButtonLayout() {
	document.getElementById('playNowImage').src = "../images/play-now-icon.png";
	document.getElementById('playNowArrowImage').src = "../images/arrow-icon.png";
	document.getElementById('playNow'). style.color = "";
	document.getElementById('accessoriesImage').src = "../images/accessories-icon.png";
	document.getElementById('accessoriesArrowImage').src = "../images/arrow-icon.png";
	document.getElementById('accessories').style.color = "";
	document.getElementById('seHomeImage').src ="../images/se-home-icon.png" ;
	document.getElementById('seHomeArrowImage').src = "../images/arrow-icon.png";
	document.getElementById('seHome').style.color = "";
	document.getElementById('supportImage').src = "../images/support-icon.png";
	document.getElementById('supportArrowImage').src = "../images/arrow-icon.png";
	document.getElementById('support').style.color = "";
}

function setIconLayout(state, action) {
	var icon;
	var arrow;
	var actionArea;
	
	if (action == "play-now") {
		icon = document.getElementById('playNowImage');
		arrow = document.getElementById('playNowArrowImage');
		actionArea = document.getElementById('playNow');
		
		icon.src = "../images/play-now-icon-selected.png";
	}
	else if (action == "accessories") {
		icon = document.getElementById('accessoriesImage');
		arrow = document.getElementById('accessoriesArrowImage');
		actionArea = document.getElementById('accessories');
		
		icon.src = "../images/accessories-icon-selected.png";
	}
	else if (action == "sehome") {
		icon = document.getElementById('seHomeImage');
		arrow = document.getElementById('seHomeArrowImage');
		actionArea = document.getElementById('seHome');
		
		icon.src = "../images/se-home-icon-selected.png";
	}
	else if (action == "support") {
		icon = document.getElementById('supportImage');
		arrow = document.getElementById('supportArrowImage');
		actionArea = document.getElementById('support');
		
		icon.src = "../images/support-icon-selected.png";
	}
	
	arrow. src = "../images/arrow-icon-selected.png";
	actionArea.style.color = "white";
}