/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.control.thread;

import com.myweather.constants.CommandConstants;
import com.myweather.constants.GeneralConstants;
import com.myweather.control.AppEngine;
import com.myweather.midlet.MyWeatherMidlet;
import com.myweather.ui.CityDetailUI;
import com.myweather.ui.WaitingDetailForm;
import com.myweather.util.BasicFunction;
import com.myweather.valueobject.ForecastDay;
import com.myweather.valueobject.LifeStyle;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.StyleSheet;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;

public class GetCityDetailThread
extends Thread
implements CommandListener {
    public CityDetailUI cityDetailUI;
    public String forecastUrl = null;
    public WaitingDetailForm waitingDetailForm;
    public int currCityId;
    public int currIndex;

    public GetCityDetailThread(CityDetailUI cityDetailUI, String forecastUrl, int currIndex) {
        this.cityDetailUI = cityDetailUI;
        this.forecastUrl = forecastUrl;
        this.currIndex = currIndex;
        this.currCityId = BasicFunction.getCustomizeCityIds()[currIndex];
        this.init();
    }

    public void init() {
        this.waitingDetailForm = new WaitingDetailForm(GeneralConstants.HEADINGS_TAB, this.cityDetailUI, false, true, StyleSheet.forcastscreenStyle);
        this.waitingDetailForm.showJustDataLoadding("");
        MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.waitingDetailForm);
    }

    public void run() {
        try {
            ForecastDay forecastDay = null;
            if (GeneralConstants.forecastMap.get(String.valueOf(this.currCityId)) != null) {
                forecastDay = (ForecastDay)GeneralConstants.forecastMap.get(String.valueOf(this.currCityId));
            } else {
                forecastDay = AppEngine.getInstance(true).getForeCastDays(BasicFunction.convertUrl(this.forecastUrl, this.currCityId));
                GeneralConstants.forecastMap.put(String.valueOf(this.currCityId), forecastDay);
            }
            if (this.waitingDetailForm.cancel) {
                throw new Exception("cancel");
            }
            this.cityDetailUI.showForecastDayList(forecastDay, 0);
            if (!GeneralConstants.IS_FREE) {
                if (this.waitingDetailForm.cancel) {
                    throw new Exception("cancel");
                }
                LifeStyle lifeStyle = null;
                if (GeneralConstants.lifeStyleMap.get(String.valueOf(this.currCityId)) != null) {
                    lifeStyle = (LifeStyle)GeneralConstants.lifeStyleMap.get(String.valueOf(this.currCityId));
                } else {
                    lifeStyle = AppEngine.getInstance(true).getLifeStyle(BasicFunction.convertUrl(GeneralConstants.LIFE_URL, this.currCityId));
                    GeneralConstants.lifeStyleMap.put(String.valueOf(this.currCityId), lifeStyle);
                }
                this.cityDetailUI.showLifeStyleList(lifeStyle);
                BasicFunction.loadRadaImage();
            }
            if (this.waitingDetailForm.cancel) {
                throw new Exception("cancel");
            }
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.cityDetailUI);
        }
        catch (Exception exp) {
            System.out.println(exp.getMessage());
        }
    }

    public void commandAction(Command command, Displayable disp) {
        if (command == CommandConstants.OK) {
            MasterCanvas.setCurrent(MyWeatherMidlet.getInstance().display, (Displayable)this.cityDetailUI);
        }
    }
}

