/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.browser.html;

import de.enough.polish.browser.Browser;
import de.enough.polish.browser.TagHandler;
import de.enough.polish.browser.html.FormListener;
import de.enough.polish.browser.html.HtmlBrowser;
import de.enough.polish.browser.html.HtmlForm;
import de.enough.polish.browser.html.HtmlSelect;
import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ImageItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TableItem;
import de.enough.polish.ui.TextField;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.Debug;
import de.enough.polish.util.HashMap;
import de.enough.polish.util.TextUtil;
import de.enough.polish.xml.SimplePullParser;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Image;

public class HtmlTagHandler
extends TagHandler
implements ItemCommandListener {
    public static final String TAG_TITLE = "title";
    public static final String TAG_STYLE = "style";
    public static final String TAG_BR = "br";
    public static final String TAG_P = "p";
    public static final String TAG_IMG = "img";
    public static final String TAG_DIV = "div";
    public static final String TAG_SPAN = "span";
    public static final String TAG_A = "a";
    public static final String TAG_B = "b";
    public static final String TAG_STRONG = "strong";
    public static final String TAG_I = "i";
    public static final String TAG_EM = "em";
    public static final String TAG_FORM = "form";
    public static final String TAG_INPUT = "input";
    public static final String TAG_BUTTON = "button";
    public static final String TAG_TEXT_AREA = "textarea";
    public static final String TAG_SELECT = "select";
    public static final String TAG_OPTION = "option";
    public static final String TAG_SCRIPT = "script";
    public static final String TAG_TABLE = "table";
    public static final String TAG_TR = "tr";
    public static final String TAG_TH = "th";
    public static final String TAG_TD = "td";
    public static final String INPUT_TYPE = "type";
    public static final String INPUT_NAME = "name";
    public static final String INPUT_VALUE = "value";
    public static final String INPUTTYPE_TEXT = "text";
    public static final String INPUTTYPE_PASSWORD = "password";
    public static final String INPUTTYPE_HIDDEN = "hidden";
    public static final String INPUTTYPE_SUBMIT = "submit";
    public static final String ATTR_HREF = "href";
    public static final String ATTR_FORM = "polish_form";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final Command CMD_LINK = new Command("Go", 4, 1);
    public static final Command CMD_SUBMIT = new Command("Submit", 8, 2);
    public static final Command CMD_BACK = new Command("Back", 2, 10);
    private HtmlForm currentForm;
    private HtmlSelect currentSelect;
    private TableItem currentTable;
    protected HtmlBrowser browser;
    public boolean textBold;
    public boolean textItalic;
    public Style textStyle;
    private FormListener formListener;

    public void register(Browser parent) {
        this.browser = (HtmlBrowser)parent;
        this.textBold = false;
        this.textItalic = false;
        parent.addTagHandler(TAG_TITLE, this);
        parent.addTagHandler(TAG_STYLE, this);
        parent.addTagHandler(TAG_BR, this);
        parent.addTagHandler(TAG_P, this);
        parent.addTagHandler(TAG_IMG, this);
        parent.addTagHandler(TAG_DIV, this);
        parent.addTagHandler(TAG_SPAN, this);
        parent.addTagHandler(TAG_A, this);
        parent.addTagHandler(TAG_B, this);
        parent.addTagHandler(TAG_STRONG, this);
        parent.addTagHandler(TAG_I, this);
        parent.addTagHandler(TAG_EM, this);
        parent.addTagHandler(TAG_FORM, this);
        parent.addTagHandler(TAG_INPUT, this);
        parent.addTagHandler(TAG_BUTTON, this);
        parent.addTagHandler(TAG_SELECT, this);
        parent.addTagHandler(TAG_OPTION, this);
        parent.addTagHandler(TAG_SCRIPT, this);
        parent.addTagHandler(TAG_TEXT_AREA, this);
        parent.addTagHandler(TAG_TABLE, this);
        parent.addTagHandler(TAG_TR, this);
        parent.addTagHandler(TAG_TH, this);
        parent.addTagHandler(TAG_TD, this);
    }

    public boolean handleTag(Container parentItem, SimplePullParser parser, String tagName, boolean opening, HashMap attributeMap, Style style) {
        String name;
        Container container;
        if (TAG_DIV.equals(tagName = tagName.toLowerCase()) || TAG_SPAN.equals(tagName)) {
            if (opening) {
                this.browser.openContainer(style);
            } else {
                container = this.browser.closeContainer();
                if (UiAccess.cast(container) instanceof TableItem) {
                    this.currentTable = (TableItem)UiAccess.cast(container);
                }
            }
        } else {
            if (TAG_SELECT.equals(tagName)) {
                if (opening) {
                    int size;
                    if (this.currentSelect != null) {
                        Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 248, "Error in HTML-Code: You cannot open a <select>-tag inside another <select>-tag.");
                        ChoiceGroup choiceGroup = this.currentSelect.getChoiceGroup();
                        this.add(choiceGroup);
                        if (this.currentForm == null) {
                            Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 254, "Error in HTML-Code: no <form> for <select> element found!");
                        } else {
                            this.currentForm.addItem(choiceGroup);
                        }
                        this.currentSelect = null;
                    }
                    String name2 = parser.getAttributeValue("name");
                    String sizeStr = parser.getAttributeValue(ATTR_SIZE);
                    try {
                        size = Integer.parseInt(sizeStr);
                    }
                    catch (NumberFormatException e) {
                        size = -1;
                    }
                    boolean isMultiple = parser.getAttributeValue(ATTR_MULTIPLE) != null;
                    this.currentSelect = new HtmlSelect(name2, size, isMultiple, style);
                } else if (this.currentSelect != null) {
                    ChoiceGroup choiceGroup = this.currentSelect.getChoiceGroup();
                    this.add(choiceGroup);
                    if (this.currentForm == null) {
                        Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 280, "Error in HTML-Code: no <form> for <select> element found!");
                    } else {
                        this.currentForm.addItem(choiceGroup);
                    }
                    this.currentSelect = null;
                } else {
                    Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 289, "Error in HTML-Code. You cannot close a <select>-tag without opening one.");
                }
                return true;
            }
            if (TAG_OPTION.equals(tagName)) {
                if (this.currentSelect != null && opening) {
                    String value = parser.getAttributeValue("value");
                    String selected = parser.getAttributeValue("selected");
                    parser.next();
                    String name3 = parser.getText();
                    if (value == null) {
                        value = name3;
                    }
                    this.currentSelect.addOption(name3, value, selected != null, style);
                }
                return true;
            }
        }
        if (opening) {
            StringItem stringItem;
            if (TAG_TITLE.equals(tagName)) {
                parser.next();
                name = parser.getText();
                Screen myScreen = this.browser.getScreen();
                if (name != null && myScreen != null) {
                    myScreen.setTitle(name);
                }
                return true;
            }
            if (TAG_STYLE.equals(tagName)) {
                parser.next();
                return true;
            }
            if (TAG_A.equals(tagName)) {
                Item linkItem;
                String href = (String)attributeMap.get(ATTR_HREF);
                parser.next();
                if (href != null) {
                    String anchorText = parser.getText();
                    if ("".equals(anchorText) && TAG_IMG.equals(parser.getName())) {
                        attributeMap.clear();
                        for (int i = 0; i < parser.getAttributeCount(); ++i) {
                            String attributeName = parser.getAttributeName(i);
                            String attributeValue = parser.getAttributeValue(i);
                            attributeMap.put(attributeName, attributeValue);
                        }
                        String src = (String)attributeMap.get("src");
                        String url = this.browser.makeAbsoluteURL(src);
                        Image image = this.browser.loadImage(url);
                        linkItem = new ImageItem(null, image, 0, (String)attributeMap.get("alt"), StyleSheet.browserlinkStyle);
                    } else {
                        linkItem = new StringItem(null, anchorText, StyleSheet.browserlinkStyle);
                    }
                    linkItem.setDefaultCommand(CMD_LINK);
                    linkItem.setItemCommandListener(this);
                    linkItem.setAttribute(ATTR_HREF, href);
                    this.addCommands(TAG_A, linkItem);
                } else {
                    linkItem = new StringItem(null, parser.getText(), StyleSheet.browsertextStyle);
                }
                if (style != null) {
                    ((Item)linkItem).setStyle(style);
                }
                this.add(linkItem);
                return true;
            }
            if (TAG_BR.equals(tagName)) {
                stringItem = new StringItem(null, null);
                stringItem.setLayout(512);
                this.add(stringItem);
                return true;
            }
            if (TAG_P.equals(tagName)) {
                stringItem = new StringItem(null, null);
                stringItem.setLayout(512);
                this.add(stringItem);
                if (opening) {
                    this.textStyle = style;
                }
                return true;
            }
            if (TAG_IMG.equals(tagName)) {
                String src = (String)attributeMap.get("src");
                String url = this.browser.makeAbsoluteURL(src);
                Image image = this.browser.loadImage(url);
                if (image != null) {
                    ImageItem item = new ImageItem(null, image, 0, "");
                    if (style != null) {
                        item.setStyle(style);
                    }
                    this.add(item);
                }
                return true;
            }
            if (TAG_TEXT_AREA.equals(tagName)) {
                parser.next();
                String value = parser.getText();
                int maxCharNumber = 500;
                String cols = (String)attributeMap.get("cols");
                String rows = (String)attributeMap.get("rows");
                if (cols != null && rows != null) {
                    try {
                        maxCharNumber = Integer.parseInt(cols) * Integer.parseInt(rows);
                    }
                    catch (Exception e) {
                        Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 421, (Object)("Unable to parse textarea cols or rows attribute: cols=" + cols + ", rows="), rows);
                    }
                }
                TextField textField = new TextField(null, value, maxCharNumber, 0, StyleSheet.browserinputStyle);
                if (style != null) {
                    textField.setStyle(style);
                }
                this.add(textField);
                if (this.currentForm != null) {
                    this.currentForm.addItem(textField);
                    textField.setAttribute(ATTR_FORM, this.currentForm);
                    String name4 = (String)attributeMap.get("name");
                    if (value == null) {
                        value = name4;
                    }
                    if (name4 != null) {
                        textField.setAttribute("name", name4);
                        textField.setAttribute("value", value);
                    }
                }
                return true;
            }
            if (TAG_BUTTON.equals(tagName) && this.currentForm != null) {
                name = (String)attributeMap.get("name");
                String value = (String)attributeMap.get("value");
                if (value == null) {
                    value = name;
                }
                StringItem buttonItem = new StringItem(null, value, StyleSheet.browserlinkStyle);
                if (style != null) {
                    buttonItem.setStyle(style);
                }
                buttonItem.setDefaultCommand(CMD_SUBMIT);
                buttonItem.setItemCommandListener(this);
                this.addCommands(TAG_INPUT, "type", INPUTTYPE_SUBMIT, buttonItem);
                this.add(buttonItem);
                this.currentForm.addItem(buttonItem);
                buttonItem.setAttribute(ATTR_FORM, this.currentForm);
                buttonItem.setAttribute("type", INPUTTYPE_SUBMIT);
                if (name != null) {
                    buttonItem.setAttribute("name", name);
                    buttonItem.setAttribute("value", value);
                }
            } else {
                if (TAG_INPUT.equals(tagName)) {
                    if (this.currentForm != null) {
                        String type = (String)attributeMap.get("type");
                        String name5 = (String)attributeMap.get("name");
                        String value = (String)attributeMap.get("value");
                        if (this.formListener != null && name5 != null) {
                            value = this.formListener.verifyInitialFormValue(this.currentForm.getAction(), name5, value);
                        }
                        if (INPUTTYPE_TEXT.equals(type) || INPUTTYPE_PASSWORD.equals(type)) {
                            TextField textField = new TextField(null, value, 100, INPUTTYPE_TEXT.equals(type) ? 0 : 65536, StyleSheet.browserinputStyle);
                            if (style != null) {
                                textField.setStyle(style);
                            }
                            this.add(textField);
                            this.currentForm.addItem(textField);
                            textField.setAttribute(ATTR_FORM, this.currentForm);
                            if (name5 != null) {
                                textField.setAttribute("name", name5);
                                if (value == null) {
                                    value = "";
                                }
                                textField.setAttribute("value", value);
                            }
                        } else if (INPUTTYPE_SUBMIT.equals(type)) {
                            if (value == null) {
                                value = name5;
                            }
                            StringItem buttonItem = new StringItem(null, value, StyleSheet.browserlinkStyle);
                            if (style != null) {
                                buttonItem.setStyle(style);
                            }
                            buttonItem.setDefaultCommand(CMD_SUBMIT);
                            buttonItem.setItemCommandListener(this);
                            this.addCommands(TAG_INPUT, "type", INPUTTYPE_SUBMIT, buttonItem);
                            this.add(buttonItem);
                            this.currentForm.addItem(buttonItem);
                            buttonItem.setAttribute(ATTR_FORM, this.currentForm);
                            buttonItem.setAttribute("type", INPUTTYPE_SUBMIT);
                            if (name5 != null) {
                                buttonItem.setAttribute("name", name5);
                                buttonItem.setAttribute("value", value);
                            }
                        } else if (INPUTTYPE_HIDDEN.equals(type)) {
                            this.currentForm.addHiddenElement(name5, value);
                        }
                    }
                    return true;
                }
                if (TAG_SCRIPT.equals(tagName)) {
                    parser.next();
                    return true;
                }
                if (TAG_TABLE.equals(tagName)) {
                    TableItem table = new TableItem();
                    table.setSelectionMode(10);
                    table.setCellContainerStyle(this.browser.getStyle());
                    if (style != null) {
                        table.setStyle(style);
                    }
                    this.currentTable = table;
                    this.browser.openContainer(table);
                    return true;
                }
                if (this.currentTable != null && TAG_TR.equals(tagName)) {
                    this.currentTable.moveToNextRow();
                    return true;
                }
                if (this.currentTable != null && TAG_TH.equals(tagName)) {
                    this.currentTable.moveToNextColumn();
                    return true;
                }
                if (this.currentTable != null && TAG_TD.equals(tagName)) {
                    this.currentTable.moveToNextColumn();
                    return true;
                }
            }
        } else if (TAG_TABLE.equals(tagName)) {
            container = this.browser.closeContainer();
            this.currentTable = UiAccess.cast(container) instanceof TableItem ? (TableItem)UiAccess.cast(container) : null;
            return true;
        }
        if (TAG_B.equals(tagName) || TAG_STRONG.equals(tagName)) {
            this.textBold = opening;
            return true;
        }
        if (TAG_I.equals(tagName) || TAG_EM.equals(tagName)) {
            this.textItalic = opening;
            return true;
        }
        if (TAG_FORM.equals(tagName)) {
            if (opening) {
                name = (String)attributeMap.get("name");
                String action = (String)attributeMap.get("action");
                String method = (String)attributeMap.get("method");
                if (method == null) {
                    method = "GET";
                }
                this.currentForm = new HtmlForm(name, action, method.toUpperCase());
            } else {
                this.currentForm = null;
            }
            return true;
        }
        return false;
    }

    private void add(Item item) {
        this.browser.add(item);
    }

    public boolean handleCommand(Command command) {
        if (command == CMD_LINK) {
            this.handleLinkCommand();
            return true;
        }
        if (command == CMD_SUBMIT) {
            this.handleSubmitCommand();
            return true;
        }
        if (command == CMD_BACK) {
            this.handleBackCommand();
            return true;
        }
        return false;
    }

    protected void handleBackCommand() {
        this.browser.goBack();
    }

    public String createGetSubmitCall() {
        Item submitItem = this.browser.getFocusedItem();
        HtmlForm form = (HtmlForm)submitItem.getAttribute(ATTR_FORM);
        while (form == null && submitItem instanceof Container) {
            submitItem = ((Container)submitItem).getFocusedItem();
            form = (HtmlForm)submitItem.getAttribute(ATTR_FORM);
        }
        return this.createGetSubmitCall(submitItem, form);
    }

    public String createGetSubmitCall(Item submitItem, HtmlForm form) {
        if (form == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.browser.makeAbsoluteURL(form.getAction()));
        Hashtable elements = form.getFormElements(this.formListener, submitItem);
        Enumeration enumeration = elements.keys();
        int separatorChar = 63;
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = (String)elements.get(name);
            value = TextUtil.encodeUrl(value);
            sb.append((char)separatorChar);
            sb.append(name).append('=').append(value);
            separatorChar = 38;
        }
        return sb.toString();
    }

    public void doPostSubmitCall(Item submitItem, HtmlForm form) {
        if (form == null) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        Hashtable elements = form.getFormElements(this.formListener, submitItem);
        Enumeration enumeration = elements.keys();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String value = (String)elements.get(name);
            value = TextUtil.encodeUrl(value);
            sb.append(name).append('=').append(value);
            if (!enumeration.hasMoreElements()) continue;
            sb.append('&');
        }
        this.browser.go(this.browser.makeAbsoluteURL(form.getAction()), sb.toString());
    }

    protected void handleSubmitCommand() {
        Item submitItem = this.browser.getFocusedItem();
        HtmlForm form = (HtmlForm)submitItem.getAttribute(ATTR_FORM);
        while (form == null && submitItem instanceof Container) {
            submitItem = ((Container)submitItem).getFocusedItem();
            form = (HtmlForm)submitItem.getAttribute(ATTR_FORM);
        }
        if (form == null) {
            return;
        }
        if (form.isPost()) {
            this.doPostSubmitCall(submitItem, form);
        } else {
            String url = this.createGetSubmitCall(submitItem, form);
            this.browser.go(url);
        }
    }

    protected void handleLinkCommand() {
        Item linkItem = this.getFocusedItemWithAttribute(ATTR_HREF, this.browser);
        String href = (String)linkItem.getAttribute(ATTR_HREF);
        if (href != null) {
            this.browser.go(this.browser.makeAbsoluteURL(href));
        } else {
            Debug.debug("error", "de.enough.polish.browser.html.HtmlTagHandler", 775, (Object)("Unable to handle link command for item " + linkItem + ": no " + ATTR_HREF), " attribute found.");
        }
    }

    protected Item getFocusedItemWithAttribute(String attribute, Container container) {
        Item item = container.getFocusedItem();
        if (item.getAttribute(attribute) == null && item instanceof Container) {
            return this.getFocusedItemWithAttribute(attribute, (Container)item);
        }
        return item;
    }

    public void commandAction(Command command, Item item) {
        this.handleCommand(command);
    }

    public void setFormListener(FormListener listener) {
        this.formListener = listener;
    }
}

