/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.log.rms;

import de.enough.polish.log.LogEntry;
import de.enough.polish.log.LogHandler;
import de.enough.polish.util.ArrayList;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class AsynchronousRmsLogHandler
extends LogHandler
implements Runnable {
    private RecordStore logStore;
    private boolean isShuttingDown;
    private ArrayList scheduledLogEntries;
    private boolean isPermanentLogError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleLogEntry(LogEntry entry) throws Exception {
        if (this.isPermanentLogError) {
            return;
        }
        if (this.scheduledLogEntries == null) {
            this.scheduledLogEntries = new ArrayList(7);
            Thread thread = new Thread(this);
            thread.start();
        }
        ArrayList arrayList = this.scheduledLogEntries;
        synchronized (arrayList) {
            this.scheduledLogEntries.add(entry);
            this.scheduledLogEntries.notify();
        }
    }

    public void exit() {
        super.exit();
        if (this.logStore != null) {
            try {
                this.logStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
            this.logStore = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.logStore == null) {
            try {
                RecordStore.deleteRecordStore((String)"j2mepolishlog");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.logStore = RecordStore.openRecordStore((String)"j2mepolishlog", (boolean)true, (int)1, (boolean)true);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("Unable to create record store: " + e);
                this.isPermanentLogError = true;
                return;
            }
        }
        while (!this.isShuttingDown) {
            Object entry;
            while (this.scheduledLogEntries.size() != 0) {
                ArrayList arrayList = this.scheduledLogEntries;
                synchronized (arrayList) {
                    entry = (LogEntry)this.scheduledLogEntries.remove(0);
                }
                try {
                    byte[] data = ((LogEntry)entry).toByteArray();
                    this.logStore.addRecord(data, 0, data.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.err.println("Unable to write log entry: " + e);
                }
            }
            try {
                entry = this.scheduledLogEntries;
                synchronized (entry) {
                    this.scheduledLogEntries.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

