/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.ItemStateListener;
import de.enough.polish.ui.ItemView;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.ArrayList;
import de.enough.polish.util.Debug;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.HashMap;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public abstract class Item {
    public static final int TRANSPARENT = -1;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_TOP = 16;
    public static final int LAYOUT_BOTTOM = 32;
    public static final int LAYOUT_VCENTER = 48;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    public static final int LAYOUT_SHRINK = 1024;
    public static final int LAYOUT_EXPAND = 2048;
    public static final int LAYOUT_VSHRINK = 4096;
    public static final int LAYOUT_VEXPAND = 8192;
    public static final int LAYOUT_2 = 16384;
    public static final int PLAIN = 0;
    public static final int HYPERLINK = 1;
    public static final int BUTTON = 2;
    public static final int INTERACTIVE = 3;
    private static final ArrayList COMMANDS = new ArrayList();
    protected int layout;
    protected ItemCommandListener itemCommandListener;
    protected Command defaultCommand;
    protected int preferredWidth;
    protected int preferredHeight;
    protected int minimumWidth;
    protected int minimumHeight;
    protected int maximumWidth;
    protected int maximumHeight;
    protected boolean isInitialized;
    public Background background;
    protected Border border;
    protected Style style;
    public int itemWidth;
    public int itemHeight;
    protected int paddingLeft;
    protected int paddingTop;
    protected int paddingRight;
    protected int paddingBottom;
    protected int paddingVertical;
    protected int paddingHorizontal;
    protected int marginLeft;
    protected int marginTop;
    protected int marginRight;
    protected int marginBottom;
    protected int contentWidth;
    protected int contentHeight;
    protected int borderWidth;
    protected int backgroundWidth;
    protected int backgroundHeight;
    public int appearanceMode;
    protected Screen screen;
    protected String cssSelector;
    protected boolean isStyleInitialised;
    protected Item parent;
    protected ArrayList commands;
    protected boolean isLayoutCenter;
    protected boolean isLayoutExpand;
    protected boolean isLayoutRight;
    public int relativeX;
    public int relativeY;
    protected int contentX;
    protected int contentY;
    public static final int NO_POSITION_SET = -9999;
    protected int internalX = -9999;
    protected int internalY;
    protected int internalWidth;
    protected int internalHeight;
    public boolean isFocused;
    protected Style labelStyle = StyleSheet.labelStyle;
    protected StringItem label;
    protected boolean useSingleRow;
    protected Style focusedStyle;
    protected boolean isPressed;
    protected boolean includeLabel;
    protected int backgroundYOffset;
    protected ItemView view;
    protected boolean preserveViewType;
    protected boolean isShown;
    private HashMap attributes;
    protected int opacity = 255;
    protected int[] opacityRgbData;
    protected boolean opacityPaintNormally;
    private ItemStateListener itemStateListener;

    protected Item() {
        this(null, 0, 0, null);
    }

    protected Item(Style style) {
        this(null, 0, 0, style);
    }

    protected Item(String label, int layout) {
        this(label, layout, 0, null);
    }

    protected Item(String label, int layout, int appearanceMode, Style style) {
        this.style = style;
        this.layout = layout;
        this.appearanceMode = appearanceMode;
        if (label != null && label.length() != 0) {
            this.setLabel(label);
        }
        if (style == null) {
            this.layout = layout;
        } else {
            this.style = style;
            this.isStyleInitialised = false;
        }
    }

    public void setLabel(String label) {
        if (this.label == null) {
            this.label = new StringItem(null, label, this.labelStyle);
            this.label.parent = this;
        } else {
            this.label.setText(label);
        }
        if (this.isInitialized) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    public String getLabel() {
        if (this.label == null) {
            return null;
        }
        return this.label.getText();
    }

    public Item getLabelItem() {
        return this.label;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        if (layout != this.layout) {
            this.layout = layout;
            if (this.isInitialized) {
                this.isInitialized = false;
                this.repaint();
            } else if (!this.isStyleInitialised && this.style != null) {
                this.setStyle(this.style);
                this.layout = layout;
            }
            if ((layout & 3) == 3) {
                this.isLayoutCenter = true;
                this.isLayoutRight = false;
            } else {
                this.isLayoutCenter = false;
                this.isLayoutRight = (layout & 2) == 2;
            }
            this.isLayoutExpand = (layout & 0x800) == 2048;
        }
    }

    public int getAppearanceMode() {
        return this.appearanceMode;
    }

    public void setAppearanceMode(int appearanceMode) {
        this.appearanceMode = appearanceMode;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        Integer opacityInt;
        ItemView viewType;
        Boolean includeLabelBool;
        Style focused;
        Integer maxHeightInt;
        Integer minHeightInt;
        Integer maxWidthInt;
        Integer minWidthInt;
        this.isInitialized = false;
        this.isStyleInitialised = true;
        this.style = style;
        if (style != StyleSheet.defaultStyle) {
            this.layout = style.layout;
            if ((this.layout & 3) == 3) {
                this.isLayoutCenter = true;
                this.isLayoutRight = false;
            } else {
                this.isLayoutCenter = false;
                this.isLayoutRight = (this.layout & 2) == 2;
            }
            this.isLayoutExpand = (this.layout & 0x800) == 2048;
        }
        if (this.isShown) {
            if (this.background != style.background) {
                if (this.background != null) {
                    this.background.hideNotify();
                }
                if (style.background != null) {
                    style.background.showNotify();
                }
            }
            if (this.border != style.border) {
                if (this.border != null) {
                    this.border.hideNotify();
                }
                if (style.border != null) {
                    style.border.showNotify();
                }
            }
        }
        this.background = style.background;
        this.border = style.border;
        this.borderWidth = this.border != null ? this.border.borderWidth : (this.background != null ? this.background.borderWidth : 0);
        this.paddingLeft = style.paddingLeft;
        this.paddingRight = style.paddingRight;
        this.paddingTop = style.paddingTop;
        this.paddingBottom = style.paddingBottom;
        this.paddingVertical = style.paddingVertical;
        this.paddingHorizontal = style.paddingHorizontal;
        this.marginLeft = style.marginLeft;
        this.marginRight = style.marginRight;
        this.marginTop = style.marginTop;
        this.marginBottom = style.marginBottom;
        Style labStyle = (Style)style.getObjectProperty(3);
        if (labStyle != null) {
            this.labelStyle = labStyle;
        } else if (this.labelStyle == null || this.isFocused) {
            this.labelStyle = StyleSheet.labelStyle;
        }
        if (this.label != null) {
            this.label.setStyle(this.labelStyle);
        }
        if ((minWidthInt = style.getIntProperty(58)) != null) {
            this.minimumWidth = minWidthInt;
        }
        if ((maxWidthInt = style.getIntProperty(59)) != null) {
            this.maximumWidth = maxWidthInt;
        }
        if ((minHeightInt = style.getIntProperty(144)) != null) {
            this.minimumHeight = minHeightInt;
        }
        if ((maxHeightInt = style.getIntProperty(145)) != null) {
            this.maximumHeight = maxHeightInt;
        }
        if ((focused = (Style)style.getObjectProperty(1)) != null) {
            this.focusedStyle = focused;
        }
        if ((includeLabelBool = style.getBooleanProperty(132)) != null) {
            this.includeLabel = includeLabelBool;
        }
        if ((viewType = (ItemView)style.getObjectProperty(39)) != null && viewType.isValid(this, style) && (this.view == null || this.view.getClass() != viewType.getClass())) {
            try {
                if (viewType.parentItem != null) {
                    viewType = (ItemView)viewType.getClass().newInstance();
                }
                viewType.parentItem = this;
                if (this.isShown) {
                    if (this.view != null) {
                        this.view.hideNotify();
                    }
                    viewType.showNotify();
                }
                this.view = viewType;
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Item", 1200, (Object)"Container: Unable to init view-type ", e);
                viewType = null;
            }
        }
        if (this.view != null) {
            this.view.setStyle(style);
        }
        if ((opacityInt = style.getIntProperty(31)) != null) {
            this.opacity = opacityInt;
        }
    }

    public int getItemWidth(int firstLineWidth, int lineWidth) {
        if (!this.isInitialized || this.itemWidth > lineWidth) {
            this.init(firstLineWidth, lineWidth);
        }
        return this.itemWidth;
    }

    public int getItemHeight(int firstLineWidth, int lineWidth) {
        if (!this.isInitialized || this.itemWidth > lineWidth) {
            this.init(firstLineWidth, lineWidth);
        }
        return this.itemHeight;
    }

    public void addCommand(Command cmd) {
        this.addCommand(cmd, null);
    }

    public void addCommand(Command cmd, Style commandStyle) {
        if (this.commands == null) {
            this.commands = new ArrayList();
        }
        if (!this.commands.contains(cmd)) {
            this.commands.add(cmd);
            if (this.appearanceMode == 0) {
                this.appearanceMode = 1;
            }
            if (this.isFocused) {
                this.showCommands();
            }
            if (this.isInitialized) {
                this.repaint();
            }
        }
    }

    public void removeCommand(Command cmd) {
        if (this.commands != null) {
            if (cmd == this.defaultCommand) {
                this.defaultCommand = null;
            }
            if (this.commands.remove(cmd)) {
                Screen scr;
                if (this.isFocused && (scr = this.getScreen()) != null) {
                    scr.removeCommand(cmd);
                }
                if (this.isInitialized) {
                    this.repaint();
                }
            }
        }
    }

    protected void repaintFully() {
        Screen scr = this.getScreen();
        if (scr != null && scr == StyleSheet.currentScreen) {
            scr.requestRepaint();
        }
    }

    protected void repaint() {
        if (this.isInitialized) {
            this.repaint(-(this.paddingLeft + this.marginLeft + this.borderWidth), -(this.paddingTop + this.marginTop + this.borderWidth), this.itemWidth, this.itemHeight);
        } else {
            this.repaintFully();
        }
    }

    protected void repaint(int relX, int relY, int width, int height) {
        Screen scr = this.getScreen();
        if (scr != null && scr == StyleSheet.currentScreen) {
            scr.requestRepaint(relX += this.getAbsoluteX(), relY += this.getAbsoluteY(), width, height + 1);
        }
    }

    public void requestInit() {
        Screen scr;
        Item p = this.parent;
        while (p != null) {
            p.isInitialized = false;
            p = p.parent;
        }
        this.isInitialized = false;
        if (this.label != null) {
            this.label.isInitialized = false;
        }
        if ((scr = this.getScreen()) != null) {
            scr.requestInit();
        }
        this.repaint();
    }

    public Screen getScreen() {
        Item p = this;
        while (p != null) {
            if (p.screen != null) {
                return p.screen;
            }
            p = p.parent;
        }
        return null;
    }

    public void setItemCommandListener(ItemCommandListener l) {
        this.itemCommandListener = l;
    }

    public void setItemCommandListener(javax.microedition.lcdui.ItemCommandListener l) {
    }

    public ItemCommandListener getItemCommandListener() {
        return this.itemCommandListener;
    }

    public void setItemStateListener(ItemStateListener listener) {
        this.itemStateListener = listener;
    }

    public ItemStateListener getItemStateListener() {
        return this.itemStateListener;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredSize(int width, int height) {
        this.preferredHeight = height;
        this.preferredWidth = width;
    }

    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    public void setDefaultCommand(Command cmd) {
        if (this.defaultCommand != null && cmd != this.defaultCommand) {
            this.addCommand(this.defaultCommand);
        }
        this.defaultCommand = cmd;
        if (cmd != null) {
            this.addCommand(cmd);
        }
    }

    public void notifyStateChanged() {
        Screen scr;
        if (this.itemStateListener != null) {
            try {
                this.itemStateListener.itemStateChanged(this);
            }
            catch (Exception e) {
                Debug.debug("error", "de.enough.polish.ui.Item", 1790, (Object)("Unable to forward ItemStateChanged event to listener " + this.itemStateListener), e);
            }
        }
        if ((scr = StyleSheet.currentScreen) == null) {
            scr = this.getScreen();
        }
        if (scr != null) {
            scr.notifyStateListener(this);
        }
    }

    public void paint(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        boolean isBottom;
        boolean isLayoutShrink;
        int availableWidth = rightBorder - leftBorder;
        if (!this.isInitialized || availableWidth < this.itemWidth) {
            this.init(rightBorder - x, availableWidth);
        }
        if (this.opacity != 255 && !this.opacityPaintNormally) {
            if (this.opacity == 0) {
                return;
            }
            int[] rgbData = this.opacityRgbData;
            if (rgbData == null) {
                this.opacityPaintNormally = true;
                this.opacityRgbData = rgbData = UiAccess.getRgbData(this, this.opacity);
                this.opacityPaintNormally = false;
            }
            DrawUtil.drawRgb(rgbData, x, y, this.itemWidth, this.itemHeight, true, g);
            return;
        }
        boolean bl = isLayoutShrink = (this.layout & 0x400) == 1024;
        if (this.includeLabel) {
            int width = this.itemWidth - this.marginLeft - this.marginRight;
            int height = this.itemHeight - this.marginTop - this.marginBottom;
            int bX = x + this.marginLeft;
            int bY = y + this.marginTop + this.backgroundYOffset;
            this.paintBackgroundAndBorder(bX, bY, width, height, g);
        }
        if (this.label != null) {
            if (this.useSingleRow) {
                this.label.paint(x, y, leftBorder, rightBorder - (this.contentWidth + this.paddingHorizontal), g);
                x += this.label.itemWidth;
                leftBorder += this.label.itemWidth;
            } else {
                this.label.paint(x, y, leftBorder, rightBorder, g);
                y += this.label.itemHeight;
            }
        }
        leftBorder += this.marginLeft + this.borderWidth + this.paddingLeft;
        rightBorder -= this.marginRight + this.borderWidth + this.paddingRight;
        if (this.isLayoutCenter && availableWidth > this.itemWidth) {
            int difference = availableWidth - this.itemWidth >> 1;
            x += difference;
            if (isLayoutShrink) {
                leftBorder += difference;
                rightBorder -= difference;
            }
        } else if (this.isLayoutRight && availableWidth > this.itemWidth) {
            x += availableWidth - this.itemWidth;
            if (isLayoutShrink) {
                leftBorder += availableWidth - this.itemWidth;
            }
        } else if (isLayoutShrink && availableWidth > this.itemWidth) {
            rightBorder -= availableWidth - this.itemWidth;
        }
        x += this.marginLeft;
        y += this.marginTop;
        if (!this.includeLabel) {
            this.paintBackgroundAndBorder(x, y, this.backgroundWidth, this.backgroundHeight, g);
        }
        x += this.borderWidth + this.paddingLeft;
        int originalContentY = y += this.borderWidth + this.paddingTop;
        boolean isVerticalCenter = (this.layout & 0x30) == 48;
        boolean isTop = !isVerticalCenter && (this.layout & 0x10) == 16;
        boolean bl2 = isBottom = !isVerticalCenter && (this.layout & 0x20) == 32;
        if (this.minimumHeight != 0) {
            int minHeight = this.minimumHeight - (2 * this.borderWidth + this.marginTop + this.marginBottom + this.paddingTop + this.paddingBottom);
            if (isVerticalCenter) {
                y += minHeight - this.contentHeight >> 1;
            } else if (isBottom) {
                y += minHeight - this.contentHeight;
            }
        }
        if (this.view != null) {
            this.view.paintContent(this, x, y, leftBorder, rightBorder, g);
        } else {
            this.paintContent(x, y, leftBorder, rightBorder, g);
        }
    }

    protected void paintBackgroundAndBorder(int x, int y, int width, int height, Graphics g) {
        if (this.background != null) {
            int bWidth = this.borderWidth;
            if (this.border != null) {
                x += bWidth;
                y += bWidth;
                width -= bWidth << 1;
                height -= bWidth << 1;
            }
            this.paintBackground(x, y, width, height, g);
            if (this.border != null) {
                x -= bWidth;
                y -= bWidth;
                width += bWidth << 1;
                height += bWidth << 1;
            }
        }
        if (this.border != null) {
            this.paintBorder(x, y, width, height, g);
        }
    }

    protected void paintBorder(int x, int y, int width, int height, Graphics g) {
        if (this.view != null) {
            this.view.paintBorder(this.border, x, y, width, height, g);
        } else {
            this.border.paint(x, y, width, height, g);
        }
    }

    protected void paintBackground(int x, int y, int width, int height, Graphics g) {
        if (this.view != null) {
            this.view.paintBackground(this.background, x, y, width, height, g);
        } else {
            this.background.paint(x, y, width, height, g);
        }
    }

    protected void init(int firstLineWidth, int lineWidth) {
        boolean isBottom;
        if (this.style != null && !this.isStyleInitialised) {
            this.setStyle(this.style);
        } else if (this.style == null) {
            this.initStyle();
        }
        int labelWidth = 0;
        int labelHeight = 0;
        if (this.label != null) {
            if (!this.label.isInitialized) {
                this.label.init(firstLineWidth, lineWidth);
            }
            labelWidth = this.label.itemWidth;
            labelHeight = this.label.itemHeight;
        }
        int noneContentWidth = this.marginLeft + this.borderWidth + this.paddingLeft + this.paddingRight + this.borderWidth + this.marginRight;
        int firstLineAdjustedWidth = firstLineWidth;
        int lineAdjustedWidth = lineWidth;
        if (this.maximumWidth != 0) {
            if (firstLineAdjustedWidth > this.maximumWidth) {
                firstLineAdjustedWidth = this.maximumWidth;
            }
            if (lineAdjustedWidth > this.maximumWidth) {
                lineAdjustedWidth = this.maximumWidth;
            }
        }
        int firstLineContentWidth = firstLineAdjustedWidth - noneContentWidth;
        int availableContentWidth = lineAdjustedWidth - noneContentWidth;
        this.contentX = this.marginLeft + this.borderWidth + this.paddingLeft;
        this.contentY = this.marginTop + this.borderWidth + this.paddingTop;
        if (this.view != null) {
            this.view.initContent(this, firstLineContentWidth, availableContentWidth);
            this.contentWidth = this.view.contentWidth;
            this.contentHeight = this.view.contentHeight;
        } else {
            this.initContent(firstLineContentWidth, availableContentWidth);
        }
        if (this.contentWidth == 0 && this.contentHeight == 0) {
            this.itemWidth = labelWidth;
            this.itemHeight = labelHeight;
            this.backgroundHeight = 0;
            this.backgroundWidth = 0;
            this.isInitialized = true;
            return;
        }
        this.itemWidth = noneContentWidth + this.contentWidth;
        if (this.itemWidth < this.minimumWidth) {
            this.itemWidth = this.minimumWidth;
        }
        if (this.maximumWidth != 0 && this.itemWidth > this.maximumWidth) {
            this.itemWidth = this.maximumWidth;
        }
        int cHeight = this.contentHeight;
        int noneContentHeight = this.marginTop + this.borderWidth + this.paddingTop + this.paddingBottom + this.borderWidth + this.marginBottom;
        boolean isVerticalCenter = (this.layout & 0x30) == 48;
        boolean bl = isBottom = !isVerticalCenter && (this.layout & 0x20) == 32;
        if (cHeight > this.contentHeight) {
            if (isVerticalCenter) {
                this.contentY = cHeight - this.contentHeight >> 1;
            } else if (isBottom) {
                this.contentY = cHeight - this.contentHeight;
            }
        }
        if (this.itemWidth + labelWidth <= lineWidth) {
            this.useSingleRow = true;
            if (this.label != null && ((this.label.layout & 0x200) != 0 || (this.layout & 0x100) == 256)) {
                this.useSingleRow = false;
                cHeight += labelHeight;
                this.contentY += labelHeight;
            }
            if (this.useSingleRow) {
                this.itemWidth += labelWidth;
                this.contentX += labelWidth;
            }
            if (cHeight + noneContentHeight < labelHeight) {
                cHeight = labelHeight - noneContentHeight;
            }
        } else {
            this.useSingleRow = false;
            cHeight += labelHeight;
            this.contentY += labelHeight;
        }
        if (this.isLayoutExpand) {
            this.itemWidth = lineWidth;
            if (this.maximumWidth != 0 && lineWidth > this.maximumWidth) {
                this.itemWidth = this.maximumWidth;
            }
        } else if (this.itemWidth > lineWidth) {
            this.itemWidth = lineWidth;
        }
        if (cHeight + noneContentHeight < this.minimumHeight) {
            cHeight = this.minimumHeight - noneContentHeight;
        }
        if (this.maximumHeight != 0 && cHeight + noneContentHeight > this.maximumHeight) {
            cHeight = this.maximumHeight - noneContentHeight;
        }
        this.itemHeight = cHeight + noneContentHeight;
        if (this.useSingleRow) {
            this.backgroundWidth = this.itemWidth - this.marginLeft - this.marginRight - labelWidth;
            this.backgroundHeight = cHeight + noneContentHeight - this.marginTop - this.marginBottom;
        } else {
            this.backgroundWidth = this.itemWidth - this.marginLeft - this.marginRight;
            this.backgroundHeight = cHeight + noneContentHeight - this.marginTop - this.marginBottom - labelHeight;
        }
        this.opacityRgbData = null;
        this.isInitialized = true;
    }

    protected void initStyle() {
        if (this.screen == null) {
            this.screen = this.parent != null ? this.getScreen() : StyleSheet.currentScreen;
        }
        if (this.style == null) {
            this.cssSelector = this.createCssSelector();
            Style myStyle = StyleSheet.getStyle(this);
            if (myStyle == null) {
                myStyle = StyleSheet.defaultStyle;
            }
            if (myStyle != null) {
                this.setStyle(myStyle);
            }
        } else {
            this.cssSelector = this.style.name;
        }
        this.isStyleInitialised = true;
    }

    protected abstract void initContent(int var1, int var2);

    protected abstract void paintContent(int var1, int var2, int var3, int var4, Graphics var5);

    protected abstract String createCssSelector();

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.appearanceMode != 0 && this.getScreen().isGameActionFire(keyCode, gameAction)) {
            return this.notifyItemPressedStart();
        }
        return false;
    }

    protected boolean handleKeyRepeated(int keyCode, int gameAction) {
        return this.handleKeyPressed(keyCode, gameAction);
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        int clearKey;
        if (this.appearanceMode != 0 && this.isPressed && this.getScreen().isGameActionFire(keyCode, gameAction)) {
            this.notifyItemPressedEnd();
            Item item = this;
            if (this.defaultCommand == null && this.parent != null) {
                item = this.parent;
            }
            if (item.defaultCommand != null) {
                if (item.itemCommandListener != null) {
                    item.itemCommandListener.commandAction(item.defaultCommand, this);
                } else {
                    Screen scr = this.getScreen();
                    if (scr != null) {
                        scr.callCommandListener(item.defaultCommand);
                    }
                }
                return true;
            }
        }
        if (keyCode == (clearKey = -8) && this.commands != null) {
            Command cmd;
            Command deleteCommand = null;
            Object[] cmds = this.commands.getInternalArray();
            for (int i = 0; i < cmds.length && (cmd = (Command)cmds[i]) != null; ++i) {
                if (cmd.getCommandType() != 3 || deleteCommand != null && deleteCommand.getPriority() <= cmd.getPriority()) continue;
                deleteCommand = cmd;
            }
            if (deleteCommand != null) {
                if (this.itemCommandListener != null) {
                    this.itemCommandListener.commandAction(deleteCommand, this);
                } else {
                    Screen scr = this.getScreen();
                    if (scr != null) {
                        scr.callCommandListener(deleteCommand);
                    }
                }
            }
        }
        return false;
    }

    protected boolean notifyItemPressedStart() {
        if (this.isPressed) {
            return false;
        }
        this.isPressed = true;
        boolean handled = false;
        return handled;
    }

    protected void notifyItemPressedEnd() {
        if (!this.isPressed) {
            return;
        }
        this.isPressed = false;
    }

    public boolean isInContentArea(int relX, int relY) {
        int contTop = this.contentY;
        if (relY < contTop || relY > contTop + this.contentHeight) {
            return false;
        }
        int contLeft = this.contentX;
        return relX >= contLeft && relX <= contLeft + this.contentWidth;
    }

    public boolean isInItemArea(int relX, int relY) {
        return relY >= 0 && relY <= this.itemHeight && relX >= 0 && relX <= Math.max(this.itemWidth, this.contentX + this.contentWidth);
    }

    public boolean isInItemArea(int relX, int relY, Item child) {
        if (child != null) {
            return child.isInItemArea(relX - child.relativeX, relY - child.relativeY);
        }
        return false;
    }

    public void addRelativeToContentRegion(ClippingRegion repaintRegion, int x, int y, int width, int height) {
        repaintRegion.addRegion(this.getAbsoluteX() + this.contentX + x, this.getAbsoluteY() + this.contentY + y, width, height);
    }

    public void addRelativeToBackgroundRegion(ClippingRegion repaintRegion, int x, int y, int width, int height) {
        repaintRegion.addRegion(this.getAbsoluteX() + this.getBackgroundX() + x - 1, this.getAbsoluteY() + this.getBackgroundY() + y - 1, width + 2, height + 2);
    }

    public void addRelativeToBackgroundRegion(Background animatedBackground, Border animatedBorder, ClippingRegion repaintRegion, int x, int y, int width, int height) {
        repaintRegion.addRegion(this.getAbsoluteX() + this.getBackgroundX() + x - 1, this.getAbsoluteY() + this.getBackgroundY() + y - 1, width + 2, height + 2);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        if (this.label != null) {
            this.label.animate(currentTime, repaintRegion);
        }
        if (this.background != null) {
            this.background.animate(this.screen, this, currentTime, repaintRegion);
        }
        if (this.border != null) {
            this.border.animate(this.screen, this, currentTime, repaintRegion);
        }
        if (this.animate()) {
            repaintRegion.addRegion(this.getAbsoluteX(), this.getAbsoluteY(), this.itemWidth, this.itemHeight);
        }
        if (this.view != null) {
            this.view.animate(currentTime, repaintRegion);
        }
    }

    public boolean animate() {
        return false;
    }

    public Style getFocusedStyle() {
        if (this.focusedStyle != null) {
            return this.focusedStyle;
        }
        if (this.parent != null) {
            return this.parent.getFocusedStyle();
        }
        return StyleSheet.focusedStyle;
    }

    protected Style focus(Style newStyle, int direction) {
        Style oldStyle = this.style;
        if (!this.isStyleInitialised && oldStyle != null) {
            this.setStyle(oldStyle);
        }
        if (newStyle == null) {
            newStyle = this.getFocusedStyle();
        }
        this.preserveViewType = true;
        this.setStyle(newStyle);
        this.preserveViewType = false;
        this.isFocused = true;
        if (this.commands != null) {
            this.showCommands();
        }
        if (oldStyle == null) {
            oldStyle = StyleSheet.defaultStyle;
        }
        return oldStyle;
    }

    public void showCommands() {
        COMMANDS.clear();
        this.addCommands(COMMANDS);
        Screen scr = this.getScreen();
        if (scr != null) {
            scr.setItemCommands(COMMANDS, this);
        }
    }

    protected void addCommands(ArrayList commandsList) {
        if (this.commands != null) {
            commandsList.addAll(this.commands);
        }
        if (this.parent != null) {
            this.parent.addCommands(commandsList);
        }
    }

    protected boolean handleCommand(Command cmd) {
        if (this.commands == null || this.itemCommandListener == null || !this.commands.contains(cmd)) {
            return false;
        }
        try {
            this.itemCommandListener.commandAction(cmd, this);
            return true;
        }
        catch (Exception e) {
            Debug.debug("error", "de.enough.polish.ui.Item", 2955, (Object)("Unable to handle command " + cmd.getLabel()), e);
            return false;
        }
    }

    protected void defocus(Style originalStyle) {
        Screen scr;
        if (this.isPressed) {
            this.notifyItemPressedEnd();
        }
        this.backgroundYOffset = 0;
        if (originalStyle != null) {
            this.setStyle(originalStyle);
        } else {
            this.background = null;
            this.border = null;
            this.style = null;
        }
        this.isFocused = false;
        if (this.commands != null && (scr = this.getScreen()) != null) {
            scr.removeItemCommands(this);
        }
    }

    protected void showNotify() {
        this.isShown = true;
        if (this.background != null) {
            this.background.showNotify();
        }
        if (this.border != null) {
            this.border.showNotify();
        }
        if (this.view != null) {
            this.view.showNotify();
        }
    }

    protected void hideNotify() {
        this.isShown = false;
        if (this.background != null) {
            this.background.hideNotify();
        }
        if (this.border != null) {
            this.border.hideNotify();
        }
        if (this.view != null) {
            this.view.hideNotify();
        }
        if (this.isPressed) {
            this.notifyItemPressedEnd();
        }
    }

    public void show(Display display) {
        Screen myScreen = this.getScreen();
        if (myScreen == null) {
            Debug.debug("warn", "de.enough.polish.ui.Item", 3068, "Unable to show this item, since the screen is not known.");
            return;
        }
        myScreen.focus(this);
        MasterCanvas.setCurrent(display, (Displayable)myScreen);
    }

    public void releaseResources() {
        if (this.background != null) {
            this.background.releaseResources();
        }
        if (this.view != null) {
            this.view.releaseResources();
        }
    }

    public void setAttribute(Object key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(key, value);
    }

    public Object getAttribute(Object key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public Item getItemAt(int relX, int relY) {
        if (this.isInItemArea(relX, relY)) {
            Item item;
            if (this.label != null && (item = this.label.getItemAt(relX, relY)) != null) {
                return item;
            }
            return this;
        }
        return null;
    }

    public int getAbsoluteX() {
        Item item;
        int absX = this.relativeX;
        if (this.label != null && this.useSingleRow && !this.isLayoutCenter && !this.isLayoutRight) {
            absX += this.contentX;
        }
        if ((item = this.parent) != null && item.label == this) {
            absX -= item.contentX;
        }
        while (item != null) {
            absX += item.relativeX + item.contentX;
            item = item.parent;
        }
        return absX;
    }

    public int getAbsoluteY() {
        int absY = this.relativeY;
        Item item = this.parent;
        if (item != null && item.label == this) {
            absY -= item.contentY;
        }
        while (item != null) {
            absY += item.relativeY + item.contentY;
            if (item instanceof Container) {
                absY += ((Container)item).yOffset;
            }
            item = item.parent;
        }
        return absY;
    }

    public int getContentX() {
        return this.contentX;
    }

    public int getContentY() {
        return this.contentY;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public int getBackgroundX() {
        if (this.includeLabel) {
            return this.marginLeft;
        }
        return this.contentX - this.paddingLeft;
    }

    public int getBackgroundY() {
        if (this.includeLabel) {
            return this.marginTop;
        }
        return this.contentY - this.paddingTop;
    }

    public int getBackgroundWidth() {
        return this.backgroundWidth;
    }

    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    public Item getParent() {
        return this.parent;
    }

    public void setParent(Item parent) {
        this.parent = parent;
    }

    public void setParent(javax.microedition.lcdui.Item parent) {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.label != null && this.label.text != null) {
            buffer.append('\"').append(this.label.text).append("\": ");
        }
        buffer.append(super.toString());
        return buffer.toString();
    }

    public boolean containsCommand(Command command) {
        return this.commands != null && this.commands.contains(command);
    }

    public Command getDefaultCommand() {
        return this.defaultCommand;
    }

    public ArrayList getItemCommands() {
        return this.commands;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public int getInternalX() {
        if (this.internalX == -9999) {
            return -1;
        }
        return this.internalX;
    }

    public int getInternalY() {
        if (this.internalX == -9999) {
            return -1;
        }
        return this.internalY;
    }

    public int getInternalWidth() {
        if (this.internalX == -9999) {
            return -1;
        }
        return this.internalWidth;
    }

    public int getInternalHeight() {
        if (this.internalX == -9999) {
            return -1;
        }
        return this.internalHeight;
    }
}

