/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SplashScreen
extends Screen {
    public static final Command DISMISS_COMMAND = new Command("Dismiss", 4, 0);
    public static final int FOREVER = 0;
    private static final int DEFAULT_TIMEOUT = 5000;
    private int timeout = 5000;
    private boolean allowTimeoutInterrupt = true;
    private long currentDisplayTimestamp;
    private Image image;

    public SplashScreen(Display display) throws IllegalArgumentException {
        super(null, false);
    }

    public SplashScreen(Display display, Style style) throws IllegalArgumentException {
        super(null, false, style);
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setAllowTimeoutInterrupt(boolean allow) {
        this.allowTimeoutInterrupt = allow;
    }

    public boolean isAllowTimeoutInterrupt() {
        return this.allowTimeoutInterrupt;
    }

    public void keyPressed(int keyCode) {
        if (this.allowTimeoutInterrupt) {
            this.doDismiss();
        }
    }

    public void pointerPressed(int x, int y) {
        if (this.allowTimeoutInterrupt) {
            this.doDismiss();
        }
    }

    public void showNotify() {
        super.showNotify();
        this.currentDisplayTimestamp = System.currentTimeMillis();
        if (this.timeout > 0) {
            Watchdog w = new Watchdog(this.timeout, this.currentDisplayTimestamp);
            w.start();
        }
    }

    public void hideNotify() {
        super.hideNotify();
        this.currentDisplayTimestamp = System.currentTimeMillis();
    }

    private void doDismiss() {
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            commandListener.commandAction(DISMISS_COMMAND, (Displayable)this);
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    protected void paintScreen(Graphics g) {
        if (this.image != null) {
            g.drawImage(this.image, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
    }

    protected String createCssSelector() {
        return "splashscreen";
    }

    private class Watchdog
    extends Thread {
        private int timeout;
        private long currentDisplayTimestamp;

        private Watchdog(int timeout, long currentDisplayTimestamp) {
            this.timeout = timeout;
            this.currentDisplayTimestamp = currentDisplayTimestamp;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.currentDisplayTimestamp == SplashScreen.this.currentDisplayTimestamp) {
                SplashScreen.this.doDismiss();
            }
        }
    }
}

