/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.Form;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.TabBar;
import de.enough.polish.ui.TabbedFormListener;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;

public class TabbedForm
extends Form {
    private final TabBar tabBar;
    private final ArrayList tabContainers;
    private int activeTabIndex;
    private TabbedFormListener tabbedFormListener;

    public TabbedForm(String title, String[] tabNames, Image[] tabImages) {
        this(title, tabNames, tabImages, null);
    }

    public TabbedForm(String title, String[] tabNames, Image[] tabImages, Style style) {
        super(title, style);
        this.tabBar = new TabBar(tabNames, tabImages, StyleSheet.tabbarStyle);
        int length = tabNames != null ? tabNames.length : tabImages.length;
        this.tabContainers = new ArrayList(length);
        this.tabContainers.add(this.container);
        for (int i = 1; i < length; ++i) {
            Container tabContainer = new Container(null, false, null, this.screenHeight);
            if (style != null) {
                tabContainer.setStyle(style, true);
            }
            tabContainer.screen = this;
            this.tabContainers.add(tabContainer);
        }
        this.setSubTitle(this.tabBar);
    }

    public int append(Item item, Style itemStyle) {
        return this.append(0, item, itemStyle);
    }

    public int append(int tabIndex, Item item) {
        return this.append(tabIndex, item, null);
    }

    public int append(int tabIndex, Item item, Style itemStyle) {
        if (item instanceof Container) {
            ((Container)item).allowCycling = false;
        }
        if (itemStyle != null) {
            item.setStyle(itemStyle);
        }
        Container tabContainer = (Container)this.tabContainers.get(tabIndex);
        tabContainer.add(item);
        return tabContainer.size() - 1;
    }

    public void insert(int tabIndex, int itemNum, Item item) {
        this.insert(tabIndex, itemNum, item, null);
    }

    public void insert(int tabIndex, int itemNum, Item item, Style itemStyle) {
        Container tabContainer;
        if (item instanceof Container) {
            ((Container)item).allowCycling = false;
        }
        if (itemStyle != null) {
            item.setStyle(itemStyle);
        }
        if (itemNum == (tabContainer = (Container)this.tabContainers.get(tabIndex)).size()) {
            tabContainer.add(item);
        } else {
            tabContainer.add(itemNum, item);
        }
    }

    public void set(int itemIndex, Item item) {
        this.set(0, itemIndex, item);
    }

    public void set(int tabIndex, int itemIndex, Item item) {
        if (item instanceof Container) {
            ((Container)item).allowCycling = false;
        }
        Container tabContainer = (Container)this.tabContainers.get(tabIndex);
        tabContainer.set(itemIndex, item);
    }

    public Item get(int tabIndex, int itemNum) {
        Container tabContainer = (Container)this.tabContainers.get(tabIndex);
        return tabContainer.get(itemNum);
    }

    public void delete(int tabIndex, Item item) {
        Container tabContainer = (Container)this.tabContainers.get(tabIndex);
        tabContainer.remove(item);
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            MasterCanvas.repaintCanvas(this);
        }
    }

    public void delete(int tabIndex, int itemIndex) {
        Container tabContainer = (Container)this.tabContainers.get(tabIndex);
        tabContainer.remove(itemIndex);
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            MasterCanvas.repaintCanvas(this);
        }
    }

    public void deleteAll(int tabIndex) {
        Container tabContainer = (Container)this.tabContainers.get(tabIndex);
        tabContainer.clear();
    }

    public int size(int tabIndex) {
        Container tabContainer = (Container)this.tabContainers.get(tabIndex);
        return tabContainer.size();
    }

    public int getTabCount() {
        return this.tabContainers.size();
    }

    public void setActiveTab(int tabIndex) {
        this.setActiveTab(tabIndex, true);
    }

    public void setActiveTab(int tabIndex, boolean focusTabBar) {
        Container tabContainer;
        if (!this.notifyTabbedChangeRequested(this.activeTabIndex, tabIndex)) {
            return;
        }
        if (this.container.isInitialized) {
            this.container.hideNotify();
            this.container.defocus(this.container.style);
        }
        int oldTabIndex = this.activeTabIndex;
        this.activeTabIndex = tabIndex;
        this.tabBar.setActiveTab(tabIndex);
        this.container = tabContainer = (Container)this.tabContainers.get(tabIndex);
        if (this.contentHeight != 0) {
            tabContainer.setScrollHeight(this.contentHeight);
        }
        if (!tabContainer.isInitialized && this.contentWidth != 0) {
            tabContainer.init(this.contentWidth, this.contentWidth);
        }
        if (tabContainer.appearanceMode != 0) {
            tabContainer.focus(tabContainer.style, 0);
        }
        tabContainer.background = null;
        tabContainer.border = null;
        if (MasterCanvas.isDisplayableShown((Displayable)this)) {
            tabContainer.showNotify();
            MasterCanvas.repaintCanvas(this);
        }
        this.notifyTabbedChangeCompleted(oldTabIndex, this.activeTabIndex);
    }

    public void setTabImage(int tabIndex, Image image) {
        this.tabBar.setImage(tabIndex, image);
    }

    public void setText(int tabIndex, String text) {
        this.tabBar.setText(tabIndex, text);
    }

    protected String createCssSelector() {
        return "tabbedform";
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        int indexBeforeEvent = this.container.getFocusedIndex();
        boolean handled = super.handleKeyPressed(keyCode, gameAction);
        int indexAfterEvent = this.container.getFocusedIndex();
        if (handled && indexAfterEvent < indexBeforeEvent && (gameAction == 5 && keyCode != 54 || gameAction == 2 && keyCode != 52)) {
            handled = false;
            this.container.focus(indexBeforeEvent);
        }
        if (!handled) {
            int nextTabIndex = this.activeTabIndex;
            if (gameAction == 5 && keyCode != 54 && (this.tabBar.isRoundtrip() || this.activeTabIndex < this.tabContainers.size() - 1)) {
                nextTabIndex = this.activeTabIndex + 1;
                if (nextTabIndex >= this.tabContainers.size()) {
                    nextTabIndex = 0;
                }
            } else if (gameAction == 2 && keyCode != 52 && (this.tabBar.isRoundtrip() || this.activeTabIndex > 0) && (nextTabIndex = this.activeTabIndex - 1) < 0) {
                nextTabIndex = this.tabContainers.size() - 1;
            }
            if (this.activeTabIndex != nextTabIndex) {
                this.setActiveTab(nextTabIndex, true);
                return true;
            }
        }
        return handled;
    }

    public void focus(Item item) {
        if (item == this.tabBar) {
            item.focus(item.getFocusedStyle(), 0);
            this.container.defocus(this.container.style);
            return;
        }
        for (int i = 0; i < this.tabContainers.size(); ++i) {
            Container tabContainer = (Container)this.tabContainers.get(i);
            if (!tabContainer.itemsList.contains(item)) continue;
            if (i != this.activeTabIndex) {
                this.setActiveTab(i);
            }
            super.focus(item);
            return;
        }
    }

    public int getSelectedTab() {
        return this.activeTabIndex;
    }

    public int getActiveTab() {
        return this.activeTabIndex;
    }

    public boolean notifyTabbedChangeRequested(int oldTabIndex, int newTabIndex) {
        if (this.tabbedFormListener != null) {
            return this.tabbedFormListener.notifyTabChangeRequested(oldTabIndex, newTabIndex);
        }
        return true;
    }

    public void notifyTabbedChangeCompleted(int oldTabIndex, int newTabIndex) {
        if (this.tabbedFormListener != null) {
            this.tabbedFormListener.notifyTabChangeCompleted(oldTabIndex, newTabIndex);
        }
    }

    public void setTabbedFormListener(TabbedFormListener listener) {
        this.tabbedFormListener = listener;
    }

    public Item getCurrentItem() {
        if (this.tabBar.isFocused) {
            return this.tabBar;
        }
        return super.getCurrentItem();
    }

    public void sizeChanged(int width, int height) {
        boolean doInit;
        boolean bl = doInit = width != this.screenWidth || height != this.originalScreenHeight;
        if (doInit) {
            this.tabBar.isInitialized = false;
        }
        super.sizeChanged(width, height);
    }

    public int addNewTab(String tabName, Image tabImage) {
        return this.addNewTab(tabName, tabImage, null);
    }

    public int addNewTab(String tabName, Image tabImage, Style tabStyle) {
        this.tabBar.addNewTab(tabName, tabImage);
        Container tabContainer = new Container(null, false, null, this.contentHeight);
        if (tabStyle != null) {
            tabContainer.setStyle(tabStyle, true);
        }
        tabContainer.screen = this;
        this.tabContainers.add(tabContainer);
        return this.tabContainers.size() - 1;
    }

    public void addNewTab(int index, String tabName, Image tabImage) {
        this.addNewTab(index, tabName, tabImage, null);
    }

    public void addNewTab(int index, String tabName, Image tabImage, Style tabStyle) {
        this.tabBar.addNewTab(index, tabName, tabImage);
        Container tabContainer = new Container(null, false, null, this.contentHeight);
        if (tabStyle != null) {
            tabContainer.setStyle(tabStyle, true);
        }
        tabContainer.screen = this;
        this.tabContainers.add(index, tabContainer);
    }

    public void removeTab(int index) {
        this.tabContainers.remove(index);
        this.tabBar.removeTab(index);
    }

    public Item getTabItem(int tabIndex) {
        return this.tabBar.getTabItem(tabIndex);
    }

    public void setTabItem(int tabIndex, Item item) {
        this.tabBar.setTabItem(tabIndex, item);
        MasterCanvas.repaintCanvas(this);
    }
}

