/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class BorderedRoundRectBackground
extends Background {
    private int color;
    private int arcWidth;
    private int arcHeight;
    private int borderColor;

    public BorderedRoundRectBackground(int color, int arcWidth, int arcHeight, int borderColor, int borderWidth) {
        this.color = color;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.borderColor = borderColor;
        this.borderWidth = borderWidth;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setColor(this.color);
        g.fillRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
        g.setColor(this.borderColor);
        g.drawRoundRect(x, y, --width, --height, this.arcWidth, this.arcHeight);
        if (this.borderWidth > 1) {
            for (int border = this.borderWidth - 1; border > 0; --border) {
                g.drawRoundRect(x + border, y + border, width - 2 * border, height - 2 * border, this.arcWidth, this.arcHeight);
            }
        }
    }

    public BorderedRoundRectBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.borderColor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.borderColor);
        dataOutputStream.writeInt(this.color);
    }
}

