/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class GradientRadialBackground
extends Background {
    private int innerColor;
    private int outerColor;
    private int start;
    private int end;
    private int centerX;
    private int centerY;

    public GradientRadialBackground(int innerColor, int outerColor, int start, int end) {
        this(innerColor, outerColor, start, end, 0, 0);
    }

    public GradientRadialBackground(int innerColor, int outerColor, int start, int end, int centerX, int centerY) {
        this.innerColor = innerColor;
        this.outerColor = outerColor;
        this.start = start;
        this.end = end;
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int steps = (Math.max(width, height) >> 1) - 1;
        int startOffset = this.start;
        int endOffset = this.end;
        if (startOffset != endOffset) {
            startOffset = startOffset * steps / 100;
            endOffset = endOffset * steps / 100;
        } else {
            endOffset = steps;
        }
        int targetX = (width >> 1) + (width >> 1) * this.centerX / 100 - startOffset;
        int targetY = (height >> 1) + (width >> 1) * this.centerY / 100 - startOffset;
        int originalX = x;
        int originalY = y;
        g.setColor(this.innerColor);
        for (int i = 0; i < steps; ++i) {
            if (i >= startOffset && i < endOffset) {
                int color = DrawUtil.getGradientColor(this.outerColor, this.innerColor, i - startOffset, steps);
                g.setColor(color);
            }
            g.fillArc(x, y, width, height, 0, 360);
            x = originalX + targetX * i / steps;
            y = originalY + targetY * i / steps;
            if (width > startOffset) {
                width -= 2;
            }
            if (height <= startOffset) continue;
            height -= 2;
        }
    }

    public GradientRadialBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.centerX = dataInputStream.readInt();
        this.centerY = dataInputStream.readInt();
        this.end = dataInputStream.readInt();
        this.innerColor = dataInputStream.readInt();
        this.outerColor = dataInputStream.readInt();
        this.start = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.centerX);
        dataOutputStream.writeInt(this.centerY);
        dataOutputStream.writeInt(this.end);
        dataOutputStream.writeInt(this.innerColor);
        dataOutputStream.writeInt(this.outerColor);
        dataOutputStream.writeInt(this.start);
    }
}

