/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PartialGradientBackground
extends Background {
    private int topColor;
    private int bottomColor;
    private int stroke;
    private int start;
    private int end;
    private int startLine;
    private int endLine;
    private int[] gradient;
    private int lastHeight;

    public PartialGradientBackground(int topColor, int bottomColor, int stroke, int start, int end) {
        this.topColor = topColor;
        this.bottomColor = bottomColor;
        this.stroke = stroke;
        this.start = start;
        this.end = end;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setStrokeStyle(this.stroke);
        int startOffset = this.startLine;
        int endOffset = this.endLine;
        if (this.gradient == null || this.lastHeight != height) {
            int steps = height;
            if (this.start != this.end) {
                this.startLine = this.start * height / 100;
                this.endLine = this.end * height / 100;
                steps = this.endLine - this.startLine;
                startOffset = this.startLine;
                endOffset = this.endLine;
            } else {
                this.endLine = height;
                endOffset = height;
            }
            this.gradient = DrawUtil.getGradient(this.topColor, this.bottomColor, steps);
            this.lastHeight = height;
        }
        g.setColor(this.topColor);
        for (int i = startOffset; i < endOffset; ++i) {
            int color = this.gradient[i - startOffset];
            g.setColor(color);
            g.drawLine(x, y + i, x + width, y + i);
        }
        g.drawLine(x, y + endOffset, x + width, y + endOffset);
        g.setStrokeStyle(0);
    }

    public PartialGradientBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomColor = dataInputStream.readInt();
        this.end = dataInputStream.readInt();
        this.endLine = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.gradient = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.gradient[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.lastHeight = dataInputStream.readInt();
        this.start = dataInputStream.readInt();
        this.startLine = dataInputStream.readInt();
        this.stroke = dataInputStream.readInt();
        this.topColor = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.bottomColor);
        dataOutputStream.writeInt(this.end);
        dataOutputStream.writeInt(this.endLine);
        if (this.gradient == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.gradient.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.gradient[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.start);
        dataOutputStream.writeInt(this.startLine);
        dataOutputStream.writeInt(this.stroke);
        dataOutputStream.writeInt(this.topColor);
    }
}

