/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.ui.UiAccess;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class TextBackground
extends Background {
    private int color;
    private int anchor;
    private int xOffset;
    private int yOffset;
    private transient StringItem item;
    private String textStyleName;

    public TextBackground(String text, String textStyleName, int color, int anchor, int xOffset, int yOffset) {
        this.textStyleName = textStyleName;
        this.color = color;
        this.anchor = anchor;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.item = new StringItem(null, text);
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (this.color != -1) {
            g.setColor(this.color);
            g.fillRect(x, y, width, height);
        }
        x += this.xOffset;
        y += this.yOffset;
        if ((this.anchor & 2) == 2) {
            y += height - this.item.getItemHeight(width, width) / 2;
        } else if ((this.anchor & 0x20) == 32) {
            y += height - this.item.getItemHeight(width, width);
        }
        this.item.paint(x, y, x, x + width, g);
    }

    public void releaseResources() {
        this.item.releaseResources();
    }

    public void hideNotify() {
        UiAccess.hideNotify(this.item);
    }

    public void showNotify() {
        Style style;
        UiAccess.showNotify(this.item);
        if (this.textStyleName != null && (style = StyleSheet.getStyle(this.textStyleName)) != null) {
            this.item.setStyle(style);
        }
    }

    public void animate(Screen screen, Item parent, long currentTime, ClippingRegion repaintRegion) {
        this.item.animate(currentTime, repaintRegion);
    }

    public TextBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.textStyleName = (String)Serializer.deserialize(dataInputStream);
        this.xOffset = dataInputStream.readInt();
        this.yOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.textStyleName, dataOutputStream);
        dataOutputStream.writeInt(this.xOffset);
        dataOutputStream.writeInt(this.yOffset);
    }
}

