/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImageBorder
extends Border {
    private String imageUrl;
    private Image topLeftImage;
    private Image topCenterImage;
    private Image topRightImage;
    private Image middleLeftImage;
    private Image middleRightImage;
    private Image bottomLeftImage;
    private Image bottomCenterImage;
    private Image bottomRightImage;
    private boolean isLoaded;

    public ImageBorder(int borderWidth, Image image) {
        this.borderWidth = borderWidth;
        this.topLeftImage = this.getImagePart(image, 0, borderWidth);
        this.topCenterImage = this.getImagePart(image, 1, borderWidth);
        this.topRightImage = this.getImagePart(image, 2, borderWidth);
        this.middleLeftImage = this.getImagePart(image, 3, borderWidth);
        this.middleRightImage = this.getImagePart(image, 4, borderWidth);
        this.bottomLeftImage = this.getImagePart(image, 5, borderWidth);
        this.bottomCenterImage = this.getImagePart(image, 6, borderWidth);
        this.bottomRightImage = this.getImagePart(image, 7, borderWidth);
        this.isLoaded = true;
    }

    public ImageBorder(int borderWidth, String imageUrl) {
        this.borderWidth = borderWidth;
        this.imageUrl = imageUrl;
    }

    private Image getImagePart(Image image, int index, int borderWidth) {
        return Image.createImage((Image)image, (int)0, (int)(index * borderWidth), (int)borderWidth, (int)borderWidth, (int)0);
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        int i;
        if (!this.isLoaded) {
            try {
                Image image = StyleSheet.getImage(this.imageUrl, this, false);
                this.topLeftImage = this.getImagePart(image, 0, this.borderWidth);
                this.topCenterImage = this.getImagePart(image, 1, this.borderWidth);
                this.topRightImage = this.getImagePart(image, 2, this.borderWidth);
                this.middleLeftImage = this.getImagePart(image, 3, this.borderWidth);
                this.middleRightImage = this.getImagePart(image, 4, this.borderWidth);
                this.bottomLeftImage = this.getImagePart(image, 5, this.borderWidth);
                this.bottomCenterImage = this.getImagePart(image, 6, this.borderWidth);
                this.bottomRightImage = this.getImagePart(image, 7, this.borderWidth);
            }
            catch (IOException e) {
                Debug.debug("error", "de.enough.polish.ui.borders.ImageBorder", 97, (Object)"unable to load image ", e);
            }
            this.isLoaded = true;
        }
        if (this.topLeftImage != null) {
            g.drawImage(this.topLeftImage, x, y, 20);
        }
        if (this.topCenterImage != null) {
            int num = (width - 2 * this.borderWidth) / this.borderWidth + 1;
            for (i = 1; i <= num; ++i) {
                g.drawImage(this.topCenterImage, x + i * this.borderWidth, y, 20);
            }
        }
        if (this.topRightImage != null) {
            g.drawImage(this.topRightImage, x + width, y, 24);
        }
        if (this.middleLeftImage != null) {
            int num = (height - 2 * this.borderWidth) / this.borderWidth + 1;
            for (i = 1; i <= num; ++i) {
                g.drawImage(this.middleLeftImage, x, y + i * this.borderWidth, 20);
            }
        }
        if (this.middleRightImage != null) {
            int num = (height - 2 * this.borderWidth) / this.borderWidth + 1;
            for (i = 1; i <= num; ++i) {
                g.drawImage(this.middleRightImage, x + width, y + i * this.borderWidth, 24);
            }
        }
        if (this.bottomLeftImage != null) {
            g.drawImage(this.bottomLeftImage, x, y + height, 36);
        }
        if (this.bottomCenterImage != null) {
            int num = (width - 2 * this.borderWidth) / this.borderWidth + 1;
            for (i = 1; i <= num; ++i) {
                g.drawImage(this.bottomCenterImage, x + i * this.borderWidth, y + height, 36);
            }
        }
        if (this.bottomRightImage != null) {
            g.drawImage(this.bottomRightImage, x + width, y + height, 40);
        }
    }

    public ImageBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.bottomCenterImage = (Image)Serializer.deserialize(dataInputStream);
        this.bottomLeftImage = (Image)Serializer.deserialize(dataInputStream);
        this.bottomRightImage = (Image)Serializer.deserialize(dataInputStream);
        this.imageUrl = (String)Serializer.deserialize(dataInputStream);
        this.isLoaded = dataInputStream.readBoolean();
        this.middleLeftImage = (Image)Serializer.deserialize(dataInputStream);
        this.middleRightImage = (Image)Serializer.deserialize(dataInputStream);
        this.topCenterImage = (Image)Serializer.deserialize(dataInputStream);
        this.topLeftImage = (Image)Serializer.deserialize(dataInputStream);
        this.topRightImage = (Image)Serializer.deserialize(dataInputStream);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        Serializer.serialize(this.bottomCenterImage, dataOutputStream);
        Serializer.serialize(this.bottomLeftImage, dataOutputStream);
        Serializer.serialize(this.bottomRightImage, dataOutputStream);
        Serializer.serialize(this.imageUrl, dataOutputStream);
        dataOutputStream.writeBoolean(this.isLoaded);
        Serializer.serialize(this.middleLeftImage, dataOutputStream);
        Serializer.serialize(this.middleRightImage, dataOutputStream);
        Serializer.serialize(this.topCenterImage, dataOutputStream);
        Serializer.serialize(this.topLeftImage, dataOutputStream);
        Serializer.serialize(this.topRightImage, dataOutputStream);
    }
}

