/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.borders;

import de.enough.polish.ui.Border;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class RoundRectBorder
extends Border {
    protected int color;
    private int arcWidth;
    private int arcHeight;

    public RoundRectBorder(int color, int borderWidth, int arcWidth, int arcHeight) {
        this.color = color;
        this.borderWidth = borderWidth;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setColor(this.color);
        g.drawRoundRect(x, y, --width, --height, this.arcWidth, this.arcHeight);
        if (this.borderWidth > 1) {
            for (int border = this.borderWidth - 1; border > 0; --border) {
                g.drawRoundRect(x + border, y + border, width - 2 * border, height - 2 * border, this.arcWidth, this.arcHeight);
            }
        }
    }

    public RoundRectBorder() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.color);
    }
}

