/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.AnimationThread;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Border;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StringItem;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.Debug;
import de.enough.polish.util.DrawUtil;
import de.enough.polish.util.ImageUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class FishEyeContainerView
extends ContainerView {
    private int minSpeed = 2;
    private int maxSpeed = -1;
    protected int[] targetXCenterPositions;
    protected int[] referenceXCenterPositions;
    protected int[] targetYCenterPositions;
    protected int[] referenceYCenterPositions;
    protected boolean isRemoveText = true;
    protected boolean includeAllItems = true;
    protected String[] labels;
    protected transient StringItem focusedLabel;
    protected transient int[][] originalRgbData;
    protected int[] originalRgbDataWidths;
    protected transient int[][] shownRgbData;
    protected int[] shownRgbDataWidths;
    protected int[] shownRgbDataHeights;
    protected int scaleFactor = 50;
    protected int startTranslucency = 200;
    protected int endTranslucency = 120;
    protected int[] targetTranslucencies;
    protected int[] currentTranslucencies;
    protected int referenceFocusedIndex;
    protected transient Background focusedBackground;
    protected Border focusedBorder;
    protected Style focusedStyle;
    protected int focusedDirection;
    protected int focusedWidth;
    protected int maxItemHeight;
    protected boolean isShowTextInTitle;
    private Object lock = new Object();

    public FishEyeContainerView() {
        this.allowsAutoTraversal = false;
        this.allowsDirectSelectionByPointerEvent = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        Object object = this.lock;
        synchronized (object) {
            if (this.shownRgbDataWidths == null) {
                Debug.debug("warn", "de.enough.polish.ui.containerviews.FishEyeContainerView", 145, "FishEyeContainerView is animated before initContent has been called");
                return;
            }
            boolean animated = false;
            if (this.targetXCenterPositions != null) {
                Item[] myItems = this.parentContainer.getItems();
                int length = myItems.length;
                for (int i = 0; i < length; ++i) {
                    int targetAlpha;
                    int currentAlpha;
                    boolean adjustAlpha;
                    int current;
                    int target = this.targetXCenterPositions[i];
                    Item item = myItems[i];
                    int halfItemWidth = item.itemWidth >> 1;
                    int distance = FishEyeContainerView.getDistance(i, this.focusedIndex, length);
                    if (distance != 0) {
                        --distance;
                    }
                    int factor = this.scaleFactor;
                    if (i != this.focusedIndex) {
                        halfItemWidth = halfItemWidth * factor / 100;
                    }
                    if ((current = item.relativeX + halfItemWidth) != target) {
                        animated = true;
                        item.relativeX = this.calculateCurrent(current, target) - halfItemWidth;
                    }
                    if (this.targetYCenterPositions != null) {
                        int halfItemHeight = item.itemHeight >> 1;
                        if (i != this.focusedIndex) {
                            halfItemHeight = halfItemHeight * factor / 100;
                        }
                        if ((current = item.relativeY + halfItemHeight) != (target = this.targetYCenterPositions[i])) {
                            animated = true;
                            item.relativeY = this.calculateCurrent(current, target) - halfItemHeight;
                        }
                    }
                    boolean bl = adjustAlpha = (currentAlpha = this.currentTranslucencies[i]) != (targetAlpha = this.targetTranslucencies[i]);
                    if (adjustAlpha) {
                        this.currentTranslucencies[i] = currentAlpha = this.calculateCurrent(currentAlpha, targetAlpha);
                    }
                    boolean isScaled = false;
                    if (factor != 100 && (current = this.shownRgbDataWidths[i]) != (target = i == this.focusedIndex ? this.originalRgbDataWidths[i] : this.originalRgbDataWidths[i] * factor / 100) && (distance < length >> 2 || i == this.focusedIndex || Math.abs(current - target) * 100 / target > 5)) {
                        animated = true;
                        isScaled = true;
                        int[] data = this.originalRgbData[i];
                        int originalWidth = this.originalRgbDataWidths[i];
                        int originalHeight = data.length / originalWidth;
                        int newWidth = this.calculateCurrent(current, target);
                        int newHeight = newWidth * originalHeight / originalWidth;
                        ImageUtil.scale(currentAlpha, data, newWidth, newHeight, originalWidth, originalHeight, this.shownRgbData[i]);
                        this.shownRgbDataWidths[i] = newWidth;
                        this.shownRgbDataHeights[i] = newHeight;
                    }
                    if (!adjustAlpha || isScaled) continue;
                    animated = true;
                    ImageUtil.setTransparencyOnlyForOpaque(currentAlpha, this.shownRgbData[i], true);
                }
            }
            if (this.isRemoveText && this.focusedLabel != null) {
                animated |= this.focusedLabel.animate();
            }
            if (this.focusedBackground != null) {
                animated |= this.focusedBackground.animate();
            }
            if (animated) {
                repaintRegion.addRegion(this.parentContainer.getAbsoluteX() - 10, this.parentContainer.getAbsoluteY() - 10, this.parentContainer.itemWidth + 20, this.parentContainer.itemHeight + 20);
            }
        }
    }

    protected static int getDistance(int i, int focused, int length) {
        int left;
        int right;
        if (i == focused) {
            return 0;
        }
        if (focused > i) {
            right = focused;
            left = i;
        } else {
            right = i;
            left = focused;
        }
        return Math.min(length - right + left, right - left);
    }

    protected int calculateCurrent(int current, int target) {
        int speed = Math.max(this.minSpeed, Math.abs(current - target) / 3);
        if (this.maxSpeed != -1 && speed > this.maxSpeed) {
            speed = this.maxSpeed;
        }
        if (current < target) {
            if ((current += speed) > target) {
                current = target;
            }
        } else if ((current -= speed) < target) {
            current = target;
        }
        return current;
    }

    protected void initContent(Item parentContainerItem, int firstLineWidth, int lineWidth) {
        Item item;
        int i;
        Container parent;
        this.isVertical = false;
        this.isHorizontal = true;
        this.parentContainer = parent = (Container)parentContainerItem;
        Item[] myItems = parent.getItems();
        int length = myItems.length;
        if (this.focusedIndex == -1 && length != 0) {
            this.focusedIndex = parent.focusedIndex != -1 ? parent.focusedIndex : 0;
            this.focusedItem = myItems[this.focusedIndex];
            this.focusedStyle = this.focusedItem.getFocusedStyle();
        }
        if (this.referenceXCenterPositions != null && this.referenceXCenterPositions.length == length) {
            return;
        }
        if (this.isRemoveText && this.focusedLabel == null) {
            this.focusedLabel = new StringItem(null, null);
        }
        if (this.isRemoveText && (this.labels == null || this.labels.length != length)) {
            this.labels = new String[length];
        }
        int maxWidth = 0;
        int maxHeight = 0;
        boolean hasFocusableItem = false;
        this.originalRgbData = new int[length][];
        this.originalRgbDataWidths = new int[length];
        this.shownRgbData = new int[length][];
        this.shownRgbDataWidths = new int[length];
        this.shownRgbDataHeights = new int[length];
        for (i = 0; i < length; ++i) {
            item = myItems[i];
            if (this.isRemoveText) {
                IconItem iconItem;
                String text = item.getLabel();
                if (text != null) {
                    this.labels[i] = text;
                    item.setLabel(null);
                } else if (item instanceof IconItem && (text = (iconItem = (IconItem)item).getText()) != null) {
                    this.labels[i] = text;
                    iconItem.setTextVisible(false);
                }
            }
            int width = item.getItemWidth(firstLineWidth, lineWidth);
            int height = item.getItemHeight(firstLineWidth, lineWidth);
            int[] data = UiAccess.getRgbData(item);
            this.originalRgbData[i] = data;
            this.originalRgbDataWidths[i] = width;
            if (this.scaleFactor == 100) {
                this.shownRgbData[i] = data;
                this.shownRgbDataWidths[i] = width;
                this.shownRgbDataHeights[i] = height;
            } else {
                int newWidth = width * this.scaleFactor / 100;
                int newHeight = height * this.scaleFactor / 100;
                int alpha = this.endTranslucency;
                this.shownRgbData[i] = new int[data.length];
                ImageUtil.scale(alpha, data, newWidth, newHeight, width, height, this.shownRgbData[i]);
                this.shownRgbDataWidths[i] = newWidth;
                this.shownRgbDataHeights[i] = newHeight;
            }
            if (item.appearanceMode != 0) {
                hasFocusableItem = true;
            }
            if (width > maxWidth) {
                maxWidth = width;
            }
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        this.maxItemHeight = maxHeight;
        this.appearanceMode = hasFocusableItem ? 3 : 0;
        this.initItemArrangement(lineWidth, myItems, length, maxWidth, maxHeight);
        for (i = 0; i < length; ++i) {
            item = myItems[i];
            int distance = FishEyeContainerView.getDistance(i, this.focusedIndex, length);
            if (distance != 0) {
                --distance;
            }
            int halfItemWidth = item.getItemWidth(lineWidth, lineWidth) >> 1;
            int halfItemHeight = item.getItemHeight(lineWidth, lineWidth) >> 1;
            if (i != this.focusedIndex) {
                int factor = this.getScaleFactor(distance, length);
                halfItemWidth = halfItemWidth * factor / 100;
                halfItemHeight = halfItemHeight * factor / 100;
            }
            item.relativeX = this.referenceXCenterPositions[i] - halfItemWidth;
            if (this.referenceYCenterPositions == null) continue;
            item.relativeY = this.referenceYCenterPositions[i] - halfItemHeight;
        }
        if (this.focusedStyle != null) {
            this.focusItem(this.focusedIndex, this.focusedItem, this.focusedDirection, this.focusedStyle);
            this.focusedItem.relativeX = this.referenceXCenterPositions[this.focusedIndex] - (this.focusedItem.getItemWidth(lineWidth, lineWidth) >> 1);
            if (this.referenceYCenterPositions != null) {
                this.focusedItem.relativeY = this.referenceYCenterPositions[this.focusedIndex] - (this.focusedItem.getItemHeight(lineWidth, lineWidth) >> 1);
            }
            this.focusedStyle = null;
        }
        this.contentWidth = lineWidth;
        int n = this.contentHeight = this.focusedLabel == null ? maxHeight : maxHeight + this.focusedLabel.getItemHeight(lineWidth, lineWidth);
        if (!this.isFocused) {
            AnimationThread.addAnimationItem(parent);
        }
    }

    protected void initItemArrangement(int lineWidth, Item[] myItems, int length, int maxWidth, int maxHeight) {
        int processed;
        this.referenceXCenterPositions = new int[length];
        this.referenceXCenterPositions[this.focusedIndex] = lineWidth >> 1;
        this.referenceFocusedIndex = this.focusedIndex;
        int completeWidth = maxWidth + maxWidth * this.scaleFactor / 100 * (length - 1) + (length - 1) * this.paddingHorizontal;
        if (this.focusedStyle != null && this.focusedItem != null) {
            UiAccess.focus(this.focusedItem, this.focusedDirection, this.focusedStyle);
            this.focusedWidth = this.focusedItem.getItemWidth(lineWidth, lineWidth);
            this.focusedItem.relativeX = lineWidth - this.focusedWidth >> 1;
        } else if (this.focusedWidth == 0) {
            this.focusedWidth = maxWidth;
        }
        int availableWidth = completeWidth > lineWidth && this.includeAllItems || completeWidth < lineWidth && this.isLayoutExpand() ? (lineWidth - this.focusedWidth >> 1) - this.paddingHorizontal : (completeWidth - this.focusedWidth >> 1) - this.paddingHorizontal;
        int availableWidthPerItem = (availableWidth << 8) / (length - 1);
        int index = this.focusedIndex - 1;
        int halfLength = length - 1 >> 1;
        int startX = availableWidth;
        for (processed = 0; processed < halfLength; ++processed) {
            if (index < 0) {
                index = length - 1;
            }
            this.referenceXCenterPositions[index] = startX - (processed * availableWidthPerItem >>> 8) - processed * this.paddingHorizontal;
            --index;
        }
        index = this.focusedIndex + 1;
        halfLength = length >> 1;
        startX = lineWidth - availableWidth - (this.paddingHorizontal >> 1);
        for (processed = 0; processed < halfLength; ++processed) {
            if (index >= length) {
                index = 0;
            }
            this.referenceXCenterPositions[index] = startX + (processed * availableWidthPerItem >>> 8) + processed * this.paddingHorizontal;
            ++index;
        }
    }

    protected int getScaleFactor(int distance, int length) {
        int factor = 100;
        factor = this.scaleFactor;
        return factor;
    }

    protected void defocus(Style originalStyle) {
        super.defocus(originalStyle);
        AnimationThread.addAnimationItem(this.parentItem);
    }

    public void focus(Style focusstyle, int direction) {
        super.focus(focusstyle, direction);
        AnimationThread.removeAnimationItem(this.parentItem);
    }

    public Style focusItem(int focIndex, Item item, int direction, Style focStyle) {
        int[] currentAlphas;
        int[] targetAlphas;
        int[] targetXPositions;
        if (this.referenceXCenterPositions == null || this.referenceXCenterPositions.length != this.parentContainer.size()) {
            this.focusedStyle = focStyle;
            this.focusedDirection = direction;
            this.focusedIndex = focIndex;
            this.focusedItem = item;
            return item.getStyle();
        }
        int difference = this.referenceFocusedIndex - focIndex;
        Item[] myItems = this.parentContainer.getItems();
        int[] targetYPositions = null;
        if (this.targetXCenterPositions == null || this.targetXCenterPositions.length != myItems.length) {
            targetXPositions = new int[myItems.length];
            if (this.referenceYCenterPositions != null) {
                targetYPositions = new int[myItems.length];
            }
            targetAlphas = new int[myItems.length];
            currentAlphas = new int[myItems.length];
        } else {
            targetXPositions = this.targetXCenterPositions;
            if (this.referenceYCenterPositions != null) {
                targetYPositions = this.targetYCenterPositions;
            }
            targetAlphas = this.targetTranslucencies;
            currentAlphas = this.currentTranslucencies;
        }
        if (this.referenceXCenterPositions.length != targetXPositions.length) {
            return item.getStyle();
        }
        for (int i = 0; i < myItems.length; ++i) {
            int nextIndex = i + difference;
            if (nextIndex < 0) {
                nextIndex = myItems.length + nextIndex;
            } else if (nextIndex >= myItems.length) {
                nextIndex -= myItems.length;
            }
            targetXPositions[i] = this.referenceXCenterPositions[nextIndex];
            if (targetYPositions != null) {
                targetYPositions[i] = this.referenceYCenterPositions[nextIndex];
            }
            targetAlphas[i] = this.calculateAlpha(FishEyeContainerView.getDistance(i, focIndex, myItems.length), myItems.length);
            currentAlphas[i] = this.endTranslucency;
        }
        this.targetXCenterPositions = targetXPositions;
        if (targetYPositions != null) {
            this.targetYCenterPositions = targetYPositions;
        }
        this.targetTranslucencies = targetAlphas;
        this.currentTranslucencies = currentAlphas;
        Style itemStyle = !item.isFocused ? super.focusItem(focIndex, item, direction, focStyle) : item.getStyle();
        this.focusedBackground = this.removeItemBackground(item);
        this.focusedBorder = this.removeItemBorder(item);
        if (this.isRemoveText) {
            if (this.isShowTextInTitle) {
                Screen scr = this.getScreen();
                if (scr != null) {
                    scr.setTitle(this.labels[focIndex]);
                }
            } else if (this.focusedLabel != null) {
                this.focusedLabel.setText(this.labels[focIndex]);
                if (this.focusedLabel.getStyle() != item.getStyle()) {
                    this.focusedLabel.setStyle(item.getStyle());
                    this.removeItemBackground(this.focusedLabel);
                    this.removeItemBorder(this.focusedLabel);
                }
            }
        }
        return itemStyle;
    }

    private int calculateAlpha(int distance, int length) {
        if (distance == 0) {
            return 255;
        }
        int alpha = this.startTranslucency - (this.startTranslucency - this.endTranslucency) * distance / (length >> 1);
        return alpha;
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int itemY;
        Item item;
        int processed;
        int index;
        int lineWidth = rightBorder - leftBorder;
        int itemLabelDiff = 0;
        if (this.isRemoveText && this.focusedLabel != null) {
            Style labelStyle = this.focusedLabel.getStyle();
            itemLabelDiff = labelStyle.paddingVertical - labelStyle.paddingBottom - labelStyle.paddingTop - labelStyle.marginBottom - labelStyle.marginTop;
        }
        if (this.focusedItem != null && (this.focusedBackground != null || this.focusedBorder != null)) {
            int backgroundHeight;
            int backgroundWidth;
            Item item2 = this.focusedItem;
            if (this.isRemoveText && this.focusedLabel != null) {
                backgroundWidth = Math.max(item2.itemWidth, this.focusedLabel.getItemWidth(lineWidth, lineWidth));
                backgroundHeight = item2.itemHeight + this.focusedLabel.itemHeight + itemLabelDiff;
            } else {
                backgroundWidth = item2.itemWidth;
                backgroundHeight = item2.itemHeight;
            }
            int backgroundX = x + (rightBorder - leftBorder >> 1) - (backgroundWidth >> 1);
            if (this.focusedBackground != null) {
                this.focusedBackground.paint(backgroundX, y, backgroundWidth, backgroundHeight, g);
            }
            if (this.focusedBorder != null) {
                this.focusedBorder.paint(backgroundX, y, backgroundWidth, backgroundHeight, g);
            }
        }
        if ((index = this.focusedIndex - (processed = myItems.length - 1 >> 1)) < 0) {
            index += myItems.length;
        }
        while (processed > 0) {
            item = myItems[index];
            int itemX = x + item.relativeX;
            itemY = y + item.relativeY;
            this.paintItem(item, index, itemX, itemY, itemX, itemX + item.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
            --processed;
            if (++index != myItems.length) continue;
            index = 0;
        }
        index = (this.focusedIndex + (myItems.length >> 1)) % myItems.length;
        for (processed = myItems.length >> 1; processed > 0; --processed) {
            item = myItems[index];
            int itemX = x + item.relativeX;
            itemY = y + item.relativeY;
            this.paintItem(item, index, itemX, itemY, itemX, itemX + item.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
            if (--index != -1) continue;
            index = myItems.length - 1;
        }
        item = this.focusedItem;
        if (item != null) {
            int itemX = x + item.relativeX;
            itemY = y + item.relativeY;
            this.paintItem(item, this.focusedIndex, itemX, itemY, itemX, itemX + item.itemWidth, clipX, clipY, clipWidth, clipHeight, g);
            if (this.isRemoveText && this.focusedLabel != null) {
                int labelX = x + (rightBorder - leftBorder >> 1) - (this.focusedLabel.getItemWidth(lineWidth, lineWidth) >> 1);
                int labelY = y + this.contentHeight - this.focusedLabel.itemHeight;
                this.focusedLabel.paint(labelX, labelY, labelX, labelX + this.focusedLabel.itemWidth, g);
            }
        }
    }

    protected void paintItem(Item item, int index, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int width = this.shownRgbDataWidths[index];
        int height = this.shownRgbDataHeights[index];
        if (index == this.focusedIndex && width == this.originalRgbDataWidths[index] && this.currentTranslucencies[index] == this.targetTranslucencies[index]) {
            super.paintItem(item, index, x, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
            return;
        }
        int[] data = this.shownRgbData[index];
        int itemLayout = item.getLayout();
        if ((itemLayout & 0x30) == 48) {
            y += this.maxItemHeight - height >> 1;
        } else if ((itemLayout & 0x20) == 32) {
            y += this.maxItemHeight - height;
        }
        DrawUtil.drawRgb(data, x, y, width, height, true, g);
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResources() {
        super.releaseResources();
        Object object = this.lock;
        synchronized (object) {
            this.originalRgbData = null;
            this.originalRgbDataWidths = null;
            this.shownRgbData = null;
            this.shownRgbDataWidths = null;
            this.shownRgbDataHeights = null;
            this.referenceXCenterPositions = null;
            this.referenceYCenterPositions = null;
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.currentTranslucencies = new int[n2];
            n = 0;
            while (n < n2) {
                this.currentTranslucencies[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.endTranslucency = dataInputStream.readInt();
        this.focusedBorder = (Border)Serializer.deserialize(dataInputStream);
        this.focusedDirection = dataInputStream.readInt();
        this.focusedStyle = (Style)Serializer.deserialize(dataInputStream);
        this.focusedWidth = dataInputStream.readInt();
        this.includeAllItems = dataInputStream.readBoolean();
        this.isRemoveText = dataInputStream.readBoolean();
        this.isShowTextInTitle = dataInputStream.readBoolean();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.labels = new String[n2];
            n = 0;
            while (n < n2) {
                this.labels[n] = (String)Serializer.deserialize(dataInputStream);
                ++n;
            }
        }
        this.lock = Serializer.deserialize(dataInputStream);
        this.maxItemHeight = dataInputStream.readInt();
        this.maxSpeed = dataInputStream.readInt();
        this.minSpeed = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.originalRgbDataWidths = new int[n2];
            n = 0;
            while (n < n2) {
                this.originalRgbDataWidths[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.referenceFocusedIndex = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.referenceXCenterPositions = new int[n2];
            n = 0;
            while (n < n2) {
                this.referenceXCenterPositions[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.referenceYCenterPositions = new int[n2];
            n = 0;
            while (n < n2) {
                this.referenceYCenterPositions[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.scaleFactor = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.shownRgbDataHeights = new int[n2];
            n = 0;
            while (n < n2) {
                this.shownRgbDataHeights[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.shownRgbDataWidths = new int[n2];
            n = 0;
            while (n < n2) {
                this.shownRgbDataWidths[n] = dataInputStream.readInt();
                ++n;
            }
        }
        this.startTranslucency = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.targetTranslucencies = new int[n2];
            n = 0;
            while (n < n2) {
                this.targetTranslucencies[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.targetXCenterPositions = new int[n2];
            n = 0;
            while (n < n2) {
                this.targetXCenterPositions[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.targetYCenterPositions = new int[n2];
            n = 0;
            while (n < n2) {
                this.targetYCenterPositions[n] = dataInputStream.readInt();
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        if (this.currentTranslucencies == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.currentTranslucencies.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.currentTranslucencies[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.endTranslucency);
        Serializer.serialize(this.focusedBorder, dataOutputStream);
        dataOutputStream.writeInt(this.focusedDirection);
        Serializer.serialize(this.focusedStyle, dataOutputStream);
        dataOutputStream.writeInt(this.focusedWidth);
        dataOutputStream.writeBoolean(this.includeAllItems);
        dataOutputStream.writeBoolean(this.isRemoveText);
        dataOutputStream.writeBoolean(this.isShowTextInTitle);
        if (this.labels == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.labels.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                Serializer.serialize(this.labels[n], dataOutputStream);
                ++n;
            }
        }
        Serializer.serialize(this.lock, dataOutputStream);
        dataOutputStream.writeInt(this.maxItemHeight);
        dataOutputStream.writeInt(this.maxSpeed);
        dataOutputStream.writeInt(this.minSpeed);
        if (this.originalRgbDataWidths == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.originalRgbDataWidths.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.originalRgbDataWidths[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.referenceFocusedIndex);
        if (this.referenceXCenterPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.referenceXCenterPositions.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.referenceXCenterPositions[n]);
                ++n;
            }
        }
        if (this.referenceYCenterPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.referenceYCenterPositions.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.referenceYCenterPositions[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.scaleFactor);
        if (this.shownRgbDataHeights == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.shownRgbDataHeights.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.shownRgbDataHeights[n]);
                ++n;
            }
        }
        if (this.shownRgbDataWidths == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.shownRgbDataWidths.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.shownRgbDataWidths[n]);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.startTranslucency);
        if (this.targetTranslucencies == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.targetTranslucencies.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.targetTranslucencies[n]);
                ++n;
            }
        }
        if (this.targetXCenterPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.targetXCenterPositions.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.targetXCenterPositions[n]);
                ++n;
            }
        }
        if (this.targetYCenterPositions == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.targetYCenterPositions.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.targetYCenterPositions[n]);
                ++n;
            }
        }
    }
}

