/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class HorizontalContainerView
extends ContainerView {
    private int xOffset;
    private boolean allowRoundTrip;
    private boolean isExpandRightLayout;

    public HorizontalContainerView() {
        this.allowsAutoTraversal = false;
        this.isHorizontal = true;
        this.isVertical = false;
    }

    protected void initContent(Item parentItm, int firstLineWidth, int lineWidth) {
        Container parent = (Container)parentItm;
        int selectedItemIndex = parent.getFocusedIndex();
        int height = 0;
        int completeWidth = 0;
        Item[] items = parent.getItems();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            int itemHeight = item.getItemHeight(lineWidth, lineWidth);
            int itemWidth = item.itemWidth;
            if (itemHeight > height) {
                height = itemHeight;
            }
            int startX = completeWidth;
            item.relativeX = completeWidth;
            item.relativeY = 0;
            completeWidth += itemWidth + this.paddingHorizontal;
            if (i == selectedItemIndex) {
                if (startX + this.xOffset < 0) {
                    this.xOffset = -startX;
                } else if (completeWidth + this.xOffset > lineWidth) {
                    this.xOffset = lineWidth - completeWidth;
                }
                this.focusedItem = item;
            }
            if (item.appearanceMode == 0) continue;
            this.appearanceMode = 3;
        }
        this.contentHeight = height;
        this.contentWidth = lineWidth < completeWidth ? lineWidth : completeWidth;
        this.isExpandRightLayout = (parent.getLayout() & 2) == 2 && (parent.getLayout() & 0x800) == 2048;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        if (this.isExpandRightLayout) {
            x = rightBorder - this.contentWidth;
        }
        super.paintContent(container, myItems, x += this.xOffset, y, leftBorder, rightBorder, clipX, clipY, clipWidth, clipHeight, g);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.allowRoundTrip = dataInputStream.readBoolean();
        this.isExpandRightLayout = dataInputStream.readBoolean();
        this.xOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.allowRoundTrip);
        dataOutputStream.writeBoolean(this.isExpandRightLayout);
        dataOutputStream.writeInt(this.xOffset);
    }
}

