/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.containerviews;

import de.enough.polish.ui.Container;
import de.enough.polish.ui.ContainerView;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.UiAccess;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class HorizontalGrayOutContainerView
extends ContainerView {
    private int targetOffset;
    private int offset = -1;
    private boolean animateItems;
    private transient int[][] inactiveIcons = null;
    private boolean isInitialized;

    public HorizontalGrayOutContainerView() {
        this.allowsAutoTraversal = false;
        this.isHorizontal = true;
        this.isVertical = false;
    }

    protected void initContent(Item parentItm, int firstLineWidth, int lineWidth) {
        Container parent = (Container)parentItm;
        int height = 0;
        int completeWidth = 0;
        Item[] items = parent.getItems();
        this.inactiveIcons = new int[items.length][];
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            int itemHeight = item.getItemHeight(lineWidth, lineWidth);
            int itemWidth = item.itemWidth;
            if (itemWidth == 0) {
                this.inactiveIcons[i] = new int[0];
                continue;
            }
            int[] rgbData = UiAccess.getRgbData(item);
            this.convertToGrayScale(rgbData);
            this.inactiveIcons[i] = rgbData;
            if (itemHeight > height) {
                height = itemHeight;
            }
            item.relativeX = completeWidth;
            item.relativeY = 0;
            completeWidth += itemWidth + this.paddingHorizontal;
            if (item.appearanceMode == 0) continue;
            this.appearanceMode = 3;
        }
        this.contentHeight = height;
        this.contentWidth = lineWidth;
        this.animateItems = true;
        this.isInitialized = true;
        if (this.focusedItem == null && items.length > 0) {
            Item item = items[0];
            this.focusItem(0, item, 5, item.getFocusedStyle());
        }
    }

    public Style focusItem(int index, Item item, int direction, Style focusedStyle) {
        if (this.isInitialized) {
            int focusOffset;
            this.targetOffset = focusOffset = (this.contentWidth >> 1) - (item.itemWidth >> 1);
            for (int i = 0; i < index; ++i) {
                this.targetOffset -= this.parentContainer.get((int)i).itemWidth;
            }
            if (this.offset == -1) {
                this.offset = this.targetOffset;
            }
            this.animateItems = true;
        }
        return super.focusItem(index, item, direction, focusedStyle);
    }

    public boolean animate() {
        boolean animated = super.animate();
        if (this.animateItems) {
            int delta = Math.abs(this.targetOffset - this.offset) / 3;
            if (delta < 1) {
                delta = 1;
            }
            if (this.targetOffset > this.offset) {
                this.offset += delta;
            } else if (this.targetOffset < this.offset) {
                this.offset -= delta;
            } else if (this.targetOffset == this.offset) {
                this.animateItems = false;
            }
            animated = true;
        }
        return animated;
    }

    protected void convertToGrayScale(int[] rgbData) {
        for (int i = 0; i < rgbData.length; ++i) {
            int color = rgbData[i];
            int alpha = 0xFF000000 & color;
            int red = 0xFF & color >>> 16;
            int green = 0xFF & color >>> 8;
            int blue = color & 0xFF;
            int brightness = (red + green + blue) / 3 & 0xFF;
            color = brightness << 0 | brightness << 8 | brightness << 16;
            rgbData[i] = color |= alpha;
        }
    }

    protected void paintContent(Container container, Item[] myItems, int x, int y, int leftBorder, int rightBorder, int clipX, int clipY, int clipWidth, int clipHeight, Graphics g) {
        int itemEndX;
        int itemStartX;
        int clipEndX = clipX + clipWidth;
        int xStart = x + this.offset;
        for (int i = 0; i < myItems.length; ++i) {
            Item item = myItems[i];
            itemStartX = xStart + item.relativeX;
            if (itemStartX >= clipEndX || (itemEndX = itemStartX + item.itemWidth) <= clipX) continue;
            int[] rgbData = this.inactiveIcons[i];
            DrawUtil.drawRgb(rgbData, itemStartX, y, item.itemWidth, item.itemHeight, true, g);
        }
        if (this.focusedItem != null) {
            int focusOffset = x + (this.contentWidth >> 1) - (this.focusedItem.itemWidth >> 1);
            g.clipRect(focusOffset, y, this.focusedItem.itemWidth, this.contentHeight);
            for (int i = 0; i < myItems.length; ++i) {
                Item item = myItems[i];
                itemStartX = xStart + item.relativeX;
                if (itemStartX >= clipEndX || (itemEndX = itemStartX + item.itemWidth) <= clipX) continue;
                item.paint(itemStartX, y, itemStartX, itemStartX + item.itemWidth, g);
            }
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    protected boolean isValid(Item parent, Style style) {
        return super.isValid(parent, style);
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.animateItems = dataInputStream.readBoolean();
        this.isInitialized = dataInputStream.readBoolean();
        this.offset = dataInputStream.readInt();
        this.targetOffset = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeBoolean(this.animateItems);
        dataOutputStream.writeBoolean(this.isInitialized);
        dataOutputStream.writeInt(this.offset);
        dataOutputStream.writeInt(this.targetOffset);
    }
}

