/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RotateScreenChangeAnimation
extends ScreenChangeAnimation {
    private int degrees;
    private int[] rotatedScreenRgb;

    public RotateScreenChangeAnimation() {
        this.useLastCanvasRgb = true;
    }

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        if (isForward) {
            this.useLastCanvasRgb = false;
            this.useNextCanvasRgb = true;
            this.degrees = 270;
        } else {
            this.useLastCanvasRgb = true;
            this.useNextCanvasRgb = false;
            this.degrees = 90;
        }
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
        this.rotatedScreenRgb = new int[width * height];
        this.animate();
    }

    protected boolean animate() {
        boolean continueAnimation;
        int[] source;
        if (this.isForwardAnimation) {
            source = this.nextCanvasRgb;
            this.degrees += 15;
            continueAnimation = this.degrees < 345;
        } else {
            source = this.lastCanvasRgb;
            this.degrees -= 15;
            continueAnimation = this.degrees > 15;
        }
        double degreeCos = Math.cos(Math.PI * (double)this.degrees / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)this.degrees / 180.0);
        ImageUtil.rotate(source, this.screenWidth, this.screenHeight, this.screenWidth >> 1, this.screenHeight >> 1, 0, degreeCos, degreeSin, this.rotatedScreenRgb, this.screenWidth, this.screenHeight);
        return continueAnimation;
    }

    protected void paintAnimation(Graphics g) {
        g.drawRGB(this.rotatedScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
    }
}

