/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ImageUtil;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ScaleScreenChangeAnimation
extends ScreenChangeAnimation {
    private int scaleFactor = 60;
    private int steps = 6;
    private int currentStep;
    private int[] nextScreenRgb;
    private boolean scaleDown;
    private int[] scaledScreenRgb;

    protected void show(Style style, Display dsplay, int width, int height, Image lstScreenImage, Image nxtScreenImage, AccessibleCanvas nxtCanvas, Displayable nxtDisplayable, boolean isForward) {
        this.nextScreenRgb = new int[width * height];
        nxtScreenImage.getRGB(this.nextScreenRgb, 0, width, 0, 0, width, height);
        this.scaledScreenRgb = new int[width * height];
        System.arraycopy(this.nextScreenRgb, 0, this.scaledScreenRgb, 0, width * height);
        super.show(style, dsplay, width, height, lstScreenImage, nxtScreenImage, nxtCanvas, nxtDisplayable, isForward);
    }

    protected boolean animate() {
        int step = this.currentStep;
        if (this.scaleDown) {
            if (--step <= 0) {
                this.scaleFactor = 200;
                this.currentStep = 0;
                this.nextScreenRgb = null;
                this.scaledScreenRgb = null;
                this.scaleDown = false;
                return false;
            }
        } else if (++step > this.steps) {
            this.scaleDown = true;
            return true;
        }
        this.currentStep = step;
        int factor = 100 + this.scaleFactor * step / this.steps;
        ImageUtil.scale(factor, this.screenWidth, this.screenHeight, this.nextScreenRgb, this.scaledScreenRgb);
        return true;
    }

    public void paintAnimation(Graphics g) {
        g.drawRGB(this.scaledScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
    }
}

