/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.URLEncoder;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.AbstractBowenList;
import com.sina.weibo.data.Bowen;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class HuatiBowenListModel
extends AbstractBowenList {
    private int currentID;
    public boolean loadHead = true;
    public boolean loading;
    public int loadHeadIndex;
    public boolean loadList;
    public int pageId = 1;
    public int pagesize = 20;
    public int count = 20;
    public String title;

    public HuatiBowenListModel(ClientManager cm, String title) {
        super(cm);
        this.title = title;
        this.getBowenList(this.pageId);
    }

    public void getBowenList(int pageid) {
        StringBuffer send = new StringBuffer();
        send.append("picsize=176&sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&page=");
        send.append(pageid);
        send.append("&pagesize=");
        send.append(this.pagesize);
        send.append("&keyword=");
        send.append(URLEncoder.encode(this.title, "UTF-8"));
        this.cm.httpEngine.HttpConnect(1, 0, String.valueOf(G.serverPath) + "searchmblog.php?" + send.toString(), null, this, HttpEngine.HIGH);
        this.loadList = true;
        this.loadHead = false;
        this.loadHeadIndex = 0;
        this.cm.setWait(true);
    }

    public boolean blockArrived(XMLDataBlock data) {
        if (this.currentID == 1) {
            return this.parseBowenList(data);
        }
        if (this.currentID == 4) {
            this.parseAddPinglun(data);
        } else if (this.currentID == 5) {
            this.parseAddZhuanfa(data);
        }
        return true;
    }

    public boolean parseBowenList(XMLDataBlock data) {
        block42: {
            if (data.getTagName().equals("rss")) break block42;
            return false;
        }
        try {
            this.bowenvc.removeAllElements();
            Vector childvc = data.getChildBlocks();
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("mblog")) {
                        Bowen item = new Bowen(this.cm);
                        Vector child2 = itemdata.getChildBlocks();
                        if (child2 != null) {
                            int j = 0;
                            while (j < child2.size()) {
                                XMLDataBlock cc = (XMLDataBlock)child2.elementAt(j);
                                if (cc.getTagName().equals("nick")) {
                                    item.userName = cc.getText();
                                } else if (cc.getTagName().equals("uid")) {
                                    item.uid = cc.getText();
                                } else if (cc.getTagName().equals("mblogid")) {
                                    item.mblogid = cc.getText();
                                } else if (cc.getTagName().equals("content")) {
                                    String s = cc.getText();
                                    item.content = Tools.replace(s, "\\n", "\n");
                                } else if (cc.getTagName().equals("rtnum")) {
                                    try {
                                        item.zhuanfa = Integer.parseInt(cc.getText());
                                    }
                                    catch (RuntimeException e) {
                                        e.printStackTrace();
                                    }
                                } else if (cc.getTagName().equals("commentnum")) {
                                    try {
                                        item.pinglun = Integer.parseInt(cc.getText());
                                    }
                                    catch (RuntimeException e) {
                                        e.printStackTrace();
                                    }
                                } else if (cc.getTagName().equals("portrait")) {
                                    item.headURL = cc.getText();
                                } else if (cc.getTagName().equals("rtrootnick")) {
                                    item.rtrootnick = cc.getText();
                                } else if (cc.getTagName().equals("rtreason")) {
                                    item.rtreason = cc.getText();
                                } else if (cc.getTagName().equals("time")) {
                                    try {
                                        item.realtime = Long.parseLong(cc.getText());
                                        item.updateTime();
                                    }
                                    catch (RuntimeException runtimeException) {}
                                } else if (cc.getTagName().equals("pic")) {
                                    item.picURL = cc.getText();
                                }
                                cc.close();
                                ++j;
                            }
                        }
                        item.updateContent();
                        this.bowenvc.addElement(item);
                    } else if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    } else if (itemdata.getTagName().equals("count")) {
                        try {
                            this.count = Integer.parseInt(itemdata.getText());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
            }
            data.close();
            this.loadHead = true;
            this.loadHeadIndex = 0;
            this.cm.updateView(14, 0);
            if (this.bowenvc.size() == 0) {
                this.cm.showAlert("\u6ca1\u6709\u641c\u7d22\u5230\u76f8\u5173\u535a\u6587\uff01");
            }
            this.cm.setWait(false);
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void handleHttpError(int httpid, String errostr) {
        this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        this.cm.setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        block7: {
            block8: {
                this.currentID = httpid;
                if (httpid != 2) break block7;
                if (this.loadHead) break block8;
                this.loading = false;
                return true;
            }
            try {
                Bowen b = (Bowen)this.bowenvc.elementAt(this.loadHeadIndex);
                b.headIcon = Image.createImage((byte[])dis, (int)0, (int)dis.length);
                int i = this.loadHeadIndex + 1;
                while (i < this.bowenvc.size()) {
                    Bowen b1 = (Bowen)this.bowenvc.elementAt(i);
                    if (b1.headURL.equals(b.headURL)) {
                        b1.headIcon = b.headIcon;
                    }
                    ++i;
                }
                this.cm.updateView(14, 1);
                ++this.loadHeadIndex;
                if (this.loadHeadIndex == this.bowenvc.size()) {
                    this.loadHead = false;
                    this.loadHeadIndex = 0;
                }
                this.loading = false;
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return this.cm.xmlEngine.receiveHttpResponse(dis, this);
    }

    public void loadNextHead() {
        this.loading = true;
        if (((Bowen)this.bowenvc.elementAt((int)this.loadHeadIndex)).headIcon == null) {
            this.cm.httpEngine.HttpConnect(2, 0, ((Bowen)this.bowenvc.elementAt((int)this.loadHeadIndex)).headURL, null, this, HttpEngine.HIGH);
        } else {
            ++this.loadHeadIndex;
            if (this.loadHeadIndex >= this.bowenvc.size()) {
                this.loadHead = false;
                this.loadHeadIndex = 0;
            }
            this.loading = false;
        }
    }
}

