/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.BackItem;
import com.sina.ui.InputBox;
import com.sina.ui.InputListener;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.ui.TabBar;
import com.sina.ui.WeiboListItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Sixin;
import com.sina.weibo.data.SixinListModel;
import com.sina.weibo.view.AbstractView;

public class SixinListView
extends AbstractView
implements ListListener,
InputListener {
    private String[] menuItems = new String[]{"\u6253\u5f00", "\u56de\u4fe1", "\u53d1\u8868\u5fae\u535a", "\u641c\u7d22", "\u9000\u51fa"};
    private SixinListModel blm;
    private String touid;

    public SixinListView(ClientManager cm, SixinListModel blm) {
        super(cm);
        this.viewID = 17;
        this.blm = blm;
        this.init();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 6: {
                this.blm.getSixinList(0);
                this.blm.pageId = 1;
                break;
            }
            case 3: {
                if (this.cm.currentAccount == null && this.blm.type == 1) break;
                this.cm.back(false);
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
                break;
            }
            case 4: {
                try {
                    this.cm.changeStageWithId(this.viewID, 11, 0, false);
                    break;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void destroy() {
    }

    public void doMenuItem(int mid) {
        switch (mid) {
            case 0: {
                this.list.doEntry();
                break;
            }
            case 1: {
                if (!(this.list.getFocusItem() instanceof WeiboListItem)) break;
                int id = ((WeiboListItem)this.list.getFocusItem()).getID();
                this.touid = ((Sixin)this.blm.sixinvc.elementAt((int)id)).uid;
                new InputBox("\u7ed9" + ((Sixin)this.blm.sixinvc.elementAt((int)id)).nick + "\u56de\u4fe1\uff1a", "", 300, 0, this, 1);
                break;
            }
            case 2: {
                this.cm.changeStageWithId(this.viewID, 5, 0, false);
                break;
            }
            case 3: {
                this.cm.search();
                break;
            }
            case 4: {
                this.cm.quit();
            }
        }
        this.closeMenuList();
    }

    private void init() {
        BackItem li = null;
        li = this.cm.currentAccount == null ? new BackItem("\u5f53\u524d\u7528\u6237\uff1a\u5fae\u535a\u6e38\u5ba2") : new BackItem("\u5f53\u524d\u7528\u6237\uff1a" + this.cm.currentAccount.nick);
        li.setPaintx(0);
        li.setPainty(0);
        li.setWidth(G.W);
        this.lrc.addItem(li);
        TabBar tb = new TabBar(G.TabItems, 3);
        tb.setPainty(li.getHeight());
        this.list = new ListRollContainer(G.W, G.H - li.getHeight() - G.MenuBarHeight - tb.getHeight());
        this.list.setPainty(li.getHeight() + tb.getHeight());
        this.lrc.addItem(this.list);
        this.lrc.addItem(tb);
        this.menu.setRight("\u5237\u65b0");
        this.update(0);
    }

    public void update(int type) {
        if (this.blm.sixinvc.size() > 0) {
            if (type == 1) {
                int i = 0;
                while (i < this.blm.sixinvc.size()) {
                    WeiboListItem li = null;
                    li = this.blm.pageId > 1 ? (WeiboListItem)this.list.getItem(i + 1) : (WeiboListItem)this.list.getItem(i);
                    Sixin bowen = (Sixin)this.blm.sixinvc.elementAt(i);
                    li.setIcon(bowen.headIcon);
                    ++i;
                }
                this.render();
                return;
            }
            if (type == 0) {
                this.list.removeAll();
                if (this.blm != null && this.blm.sixinvc != null) {
                    if (this.blm.pageId > 1) {
                        ListItem li = new ListItem("\u4e0a\u4e00\u9875", -1, (ListListener)this, this.list, 1);
                        this.list.addItem(li);
                    }
                    this.blm.loadList = false;
                    int i = 0;
                    while (i < this.blm.sixinvc.size()) {
                        Sixin bowen = (Sixin)this.blm.sixinvc.elementAt(i);
                        WeiboListItem li = new WeiboListItem(bowen.shownick, bowen.time, bowen.content, "", i, this, this.list);
                        li.setIcon(bowen.headIcon);
                        this.list.addItem(li);
                        ++i;
                    }
                    if (this.blm.count > this.blm.pagesize * this.blm.pageId) {
                        ListItem li = new ListItem("\u4e0b\u4e00\u9875", -2, (ListListener)this, this.list, 1);
                        this.list.addItem(li);
                    }
                }
            }
        } else {
            this.list.removeAll();
            ListItem li = new ListItem("\u8bf7\u5237\u65b0\u6570\u636e", -99, (ListListener)this, this.list, 1);
            this.list.addItem(li);
        }
        this.list.gotFocus((byte)1);
        this.render();
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            this.cm.changeStageWithObject(this.viewID, 18, this.blm.sixinvc.elementAt(id), false);
        } else if (id == -1) {
            if (this.blm.pageId > 1) {
                this.blm.getSixinList(--this.blm.pageId);
            }
        } else if (id == -2) {
            this.blm.getSixinList(++this.blm.pageId);
        } else if (id == -99) {
            this.blm.getSixinList(0);
        }
    }

    protected void showMenu() {
        if (this.menu.empty()) {
            int i = 0;
            while (i < this.menuItems.length) {
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
                ++i;
            }
        }
        this.openMenuList();
    }

    public void tick(long time) {
        if (this.blm.loadHead && !this.blm.loading && this.blm.sixinvc.size() > 0) {
            this.blm.loadNextHead();
        }
    }

    public void setText(String text, int id) {
        if (text != null && !"".equals(text)) {
            this.blm.sendSixin(text, this.touid);
        }
    }
}

