/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.sina.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeStamp {
    Calendar time = Calendar.getInstance();
    static final long ONE_DAY = 86400000L;

    public TimeStamp(long t) {
        TimeZone tz = this.time.getTimeZone();
        try {
            this.time.setTime(new Date(t));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TimeStamp(String t) {
        this(Long.parseLong(t));
    }

    public int getDays() {
        Calendar now = Calendar.getInstance();
        long lDiff = now.getTime().getTime() - this.time.getTime().getTime();
        if (lDiff >= 0L && lDiff < 86400000L) {
            return 0;
        }
        if (lDiff >= 86400000L) {
            return -1;
        }
        return (int)(1L + lDiff * -1L / 86400000L);
    }

    public int inSeconds() {
        return 0;
    }

    public boolean isToday() {
        long now = System.currentTimeMillis();
        long time = now % 86400000L;
        long lDiff = now - this.time.getTime().getTime();
        return lDiff >= 0L && lDiff < time;
    }

    public String toString() {
        int nDay = this.time.get(5);
        int nMonth = this.time.get(2) + 1;
        int nYear = this.time.get(1);
        int nHour = this.time.get(11);
        int nMinute = this.time.get(12);
        StringBuffer sb = new StringBuffer();
        if (this.isToday()) {
            this.appendTime(nHour, nMinute, sb);
        } else {
            this.appendDate(nDay, nMonth, sb);
            this.appendTime(nHour, nMinute, sb);
        }
        return sb.toString();
    }

    private void appendTime(int nHour, int nMinute, StringBuffer sb) {
        if (nHour < 10) {
            sb.append('0');
            sb.append(nHour);
        } else {
            sb.append(nHour);
        }
        sb.append(':');
        if (nMinute < 10) {
            sb.append('0');
            sb.append(nMinute);
        } else {
            sb.append(nMinute);
        }
    }

    private void appendDate(int nDay, int nMonth, StringBuffer sb) {
        sb.append(nMonth);
        sb.append('-');
        if (nDay < 10) {
            sb.append('0');
            sb.append(nDay);
        } else {
            sb.append(nDay);
        }
    }
}

