/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.sina.widget;

import com.sonyericsson.sina.img.Images;
import com.sonyericsson.sina.util.DynamicItem;
import com.sonyericsson.sina.util.TimeStamp;
import com.sonyericsson.sina.widget.ItemHolder;
import java.io.UnsupportedEncodingException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SinaItemPresenter {
    private static final int FONT_COLOR = 0;
    private static final int FONT_COLOR_BLEND1 = 0x555555;
    private static final int FONT_COLOR_BLEND = 7105418;
    private static final int SPRITES_COLUMS = 13;
    private static final int MARK_Y_OFFSET = 3;
    private static final int MARK_X_OFFSET = 4;
    public static final int MODE_SMALL = 0;
    public static final int MODE_ANIMATION = 1;
    public static final int MODE_INTERACTIVE = 2;
    public static final int MODE_FULLSCREEN = 3;
    public int xTextOffset;
    private static final int LT = 20;
    private static final int LB = 36;
    private static final int RB = 40;
    public static final int HIDDEN = 0;
    public static final int FOCUSED = 1;
    public static final int UNFOCUSED = 2;
    public static final int MAX_STEPS = 10;
    public static final int HEIGHT_BG = 55;
    public static final int WIDTH_BG = 210;
    public static final int Y_INCREASE_1ST = 5;
    public static final int H_ADD_INTERACTIVE = 50;
    public static final int MARGIN_LEFT_2ND = 10;
    public static final int H_SHOW_2ND = 35;
    public static final int H_HIDE_2ND = 20;
    public static final int X_INCREASE_2ND = 1;
    public static final int Y_INCREASE_2ND = 3;
    public static final int WIDTH_2ND = 190;
    public static final int HEIGHT_2ND = 49;
    public static final int MARGIN_LEFT_3RD = 18;
    public static final int H_SHOW_3RD = 25;
    public static final int H_HIDE_3RD = 30;
    public static final int X_INCREASE_3RD = 1;
    public static final int Y_INCREASE_3RD = 2;
    public static final int WIDTH_3RD = 174;
    public static final int HEIGHT_3RD = 45;
    public static final int MARGIN_LEFT_4TH = 24;
    public static final int H_SHOW_4TH = 15;
    public static final int H_HIDE_4TH = 40;
    public static final int X_INCREASE_4TH = 1;
    public static final int Y_INCREASE_4TH = 1;
    public static final int WIDTH_4TH = 162;
    public static final int HEIGHT_4TH = 45;
    private static final int SPRITE_WIDTH = 15;
    private static final int ATTACH_WIDTH = 22;
    private static final int HEIGHT_LINE = 20;
    public static final Font TEXT_FONT = Font.getFont((int)0, (int)0, (int)8);
    public int width;
    public int height;
    private int fnameLenLimit = 10;
    private byte[] fnameBytesArray = new byte[this.fnameLenLimit];
    public int id;
    private String newFname = null;

    public void draw(Graphics g, int x, int y, DynamicItem item, int id) {
        boolean isBlend = false;
        this.id = id;
        switch (this.id) {
            case 1: {
                if (ItemHolder.mode == 2) {
                    g.drawImage(Images.ITEM_BG_FOCUSED, x, y, 36);
                    break;
                }
                g.drawImage(Images.ITEM_BG, x, y, 36);
                break;
            }
            case 2: {
                if (ItemHolder.mode == 0) {
                    isBlend = true;
                    g.drawImage(Images.ITEM_BG_BLEND1, x, y, 36);
                    break;
                }
                g.drawImage(Images.ITEM_BG, x, y, 36);
                break;
            }
            case 3: {
                if (ItemHolder.mode == 0) {
                    isBlend = true;
                    g.drawImage(Images.ITEM_BG_BLEND, x, y, 36);
                    break;
                }
                g.drawImage(Images.ITEM_BG, x, y, 36);
                break;
            }
            case 4: {
                if (ItemHolder.mode == 0) {
                    isBlend = true;
                    g.drawImage(Images.ITEM_BG_BLEND, x, y, 36);
                    break;
                }
                g.drawImage(Images.ITEM_BG, x, y, 36);
            }
        }
        if (item == null) {
            item = this.setTempData();
        }
        if (item.img != null) {
            if (isBlend) {
                this.drawImage(g, x, y, item.imgBlend);
            } else {
                this.drawImage(g, x, y, item.img);
            }
        } else if (isBlend) {
            this.drawImage(g, x, y, Images.DEFAULT_BLEND);
        } else {
            this.drawImage(g, x, y, Images.DEFAULT);
        }
        if (!isBlend) {
            g.setColor(0xFFFFFF);
            g.drawRect(x + 1, y - 54, 51, 51);
        }
        g.setFont(TEXT_FONT);
        g.setColor(6170624);
        int firstLine = this.get1stLine(y);
        if (item.fname != null) {
            int len = 0;
            try {
                len = item.fname.getBytes("GB2312").length;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (len > 10) {
                this.getNewFname(item);
                g.drawSubstring(this.newFname, 0, this.newFname.length(), x + 55, firstLine, 36);
            } else {
                g.drawString(item.fname, x + 55, firstLine, 36);
            }
        }
        this.drawBlog(g, x, y, item, isBlend);
    }

    public DynamicItem setTempData() {
        DynamicItem item = new DynamicItem();
        item.type = 2;
        item.ctime = new TimeStamp(System.currentTimeMillis()).toString();
        item.fname = "\u6211";
        item.flogo = "";
        item.setStrMessage("\u65e0\u6cd5\u83b7\u53d6\u535a\u6587!");
        item.hasAttach = false;
        item.img = null;
        return item;
    }

    private void getNewFname(DynamicItem item) {
        this.newFname = item.fname.substring(0, 5);
        int i = 5;
        try {
            while (this.newFname.getBytes("GB2312").length < 10) {
                this.newFname = String.valueOf(this.newFname) + item.fname.substring(i, i + 1);
                ++i;
            }
            this.newFname = String.valueOf(this.newFname) + "...";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setTextColor(Graphics g, boolean isBlend) {
        if (isBlend) {
            if (this.id == 2) {
                g.setColor(0x555555);
            } else if (this.id == 3 || this.id == 4) {
                g.setColor(7105418);
            }
        } else {
            g.setColor(0);
        }
    }

    private void drawImage(Graphics g, int x, int y, Image img) {
        if (img != null) {
            int height = img.getHeight() < 50 ? img.getHeight() : 50;
            int width = img.getWidth() < 50 ? img.getWidth() : 50;
            g.drawRegion(img, 0, 0, width, height, 0, x + 2, y + 3 - 55, 20);
        }
    }

    private void drawBlog(Graphics g, int x, int y, DynamicItem item, boolean isBlend) {
        int firstLine = this.get1stLine(y);
        int secondLine = y - 5;
        this.drawIcon(item, g, x + 210, secondLine, isBlend, 40);
        g.setColor(6170624);
        g.drawString(item.ctime, x + 210 - 4, firstLine, 40);
        if (item.strBlog != null) {
            this.setTextColor(g, isBlend);
            if (item.hasAttach) {
                g.clipRect(x + 55, secondLine - 20, 210 - x - 55 - 22 - 4, 20);
            } else {
                g.clipRect(x + 55, secondLine - 20, 210 - x - 55 - 4, 20);
            }
            if (item.sprites == null) {
                if (this.id == 1) {
                    if (item.strBlog.length() > 8) {
                        g.drawSubstring(item.strBlog, 0, item.strBlog.length(), x + 55 + this.xTextOffset, secondLine, 36);
                    } else {
                        g.drawSubstring(item.strBlog, 0, item.strBlog.length(), x + 55, secondLine, 36);
                    }
                } else {
                    g.drawSubstring(item.strBlog, 0, item.strBlog.length(), x + 55, secondLine, 36);
                }
            }
        }
    }

    private void drawIcon(DynamicItem item, Graphics g, int x, int firstLine, boolean isBlend, int rb) {
        if (item.hasAttach) {
            if (isBlend) {
                g.drawImage(Images.PHOTO_BLEND, x, firstLine, rb);
            } else {
                g.drawImage(Images.PHOTO, x, firstLine, rb);
            }
        }
    }

    private int get1stLine(int y) {
        return y - 30;
    }

    private void drawScript(DynamicItem item, Graphics g, int x, int y, boolean isBlend) {
        if (this.id == 1) {
            x += this.xTextOffset;
        }
        int[][] s = item.sprites;
        int textWidth = 0;
        int j = 6;
        Font font = TEXT_FONT;
        g.setFont(font);
        int i = 0;
        while (i < item.sprites.length) {
            g.drawSubstring(item.strBlog, j, s[i][0] - j, x, y, 36);
            textWidth = font.substringWidth(item.strBlog, j, s[i][0] - j);
            x += textWidth;
            j = s[i][0] + s[i][1];
            int iSprite = s[i][2];
            int ySprite = 0;
            int xSprite = iSprite % 13;
            ySprite = iSprite == 0 ? 0 : iSprite / 13;
            Image sprite = null;
            g.drawRegion(sprite, 15 * xSprite, 15 * ySprite, 15, 15, 0, x, y, 36);
            x += 15;
            ++i;
        }
        g.drawSubstring(item.strBlog, j, item.strBlog.length() - j, x, y, 36);
    }
}

