/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.httpfacebook.http;

import com.sonyericsson.httpfacebook.http.ConnectionFactory;
import com.sonyericsson.httpfacebook.http.DefaultConnectionFactory;
import com.sonyericsson.httpfacebook.http.HttpRequest;
import com.sonyericsson.httpfacebook.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connection;
import javax.microedition.io.HttpConnection;

public abstract class HttpUtil {
    public static final int PROTOCOL_VERSION_1_1 = 1;
    private static ConnectionFactory connectionFactory = new DefaultConnectionFactory();

    private static void setPrioritisedRequestHeader(HttpConnection conn, Hashtable headers, String property) throws IOException {
        String value = (String)headers.remove(property);
        if (value != null) {
            conn.setRequestProperty(property, value);
        }
    }

    private static void setRequestHeaders(HttpConnection conn, HttpRequest request) throws IOException {
        Hashtable headers = request.getHeaders();
        if (headers != null) {
            Enumeration keys = headers.keys();
            HttpUtil.setPrioritisedRequestHeader(conn, headers, "Content-Type");
            HttpUtil.setPrioritisedRequestHeader(conn, headers, "Content-Length");
            HttpUtil.setPrioritisedRequestHeader(conn, headers, "MIME-Version");
            while (keys.hasMoreElements()) {
                String property = (String)keys.nextElement();
                String value = (String)headers.get(property);
                conn.setRequestProperty(property, value);
            }
        }
    }

    private static void writeBody(HttpConnection conn, HttpRequest request) throws IOException {
        OutputStream os = null;
        try {
            os = conn.openOutputStream();
            request.writeBody(os);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void readResponseBody(HttpConnection conn, HttpRequest request) throws IOException {
        InputStream is = null;
        try {
            is = conn.openInputStream();
            request.readResponseBody(is);
        }
        finally {
            IOUtil.closeInputStream(is);
        }
    }

    private static boolean doRequest(HttpRequest request, boolean useOverrideMethod, int protocolVersion) throws IOException {
        HttpConnection conn = null;
        System.out.println(">>>>>>>>>>>>> doRequest (request + true + protocol)");
        try {
            conn = (HttpConnection)connectionFactory.open(request.getURL());
            System.out.println(">>>>>>>>>>>>> doRequest (request + true + protocol) - conn: " + conn);
            String method = request.getMethod();
            System.out.println(">>>>>>>>>>>>> doRequest (request + true + protocol) - method: " + method);
            if (!useOverrideMethod) {
                System.out.println(">>>>>>>>>>>>> doRequest (request + true + protocol) - !useOverrideMethod");
                try {
                    conn.setRequestMethod(method);
                }
                catch (IOException e) {
                    useOverrideMethod = true;
                }
            }
            if (useOverrideMethod) {
                System.out.println(">>>>>>>>>>>>> doRequest (request + true + protocol) - useOverrideMethod");
                conn.setRequestMethod("POST");
                conn.setRequestProperty("X-HTTP-Method-Override", method);
                conn.setRequestProperty("Content-Length", "0");
            }
            HttpUtil.setRequestHeaders(conn, request);
            if (method.equals("POST") || method.equals("PUT")) {
                System.out.println(">>>>>>>>>>>>> doRequest (request + true + protocol) - method: POST or PUT");
                HttpUtil.writeBody(conn, request);
            }
            request.setResponse(conn.getResponseCode(), conn.getResponseMessage());
            try {
                request.setContentLength(Integer.parseInt(conn.getHeaderField("Content-Length")));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            HttpUtil.readResponseBody(conn, request);
        }
        finally {
            System.out.println(">>>>>>>>>>>>> doRequest (request + true + protocol) - closing conn: " + conn);
            IOUtil.closeConnection((Connection)conn);
        }
        return useOverrideMethod;
    }

    public static void setConnectionFactory(ConnectionFactory factory) {
        connectionFactory = factory;
    }

    public static void doRequest(HttpRequest request, int protocolVersion) throws IOException {
        boolean usedOverrideMethod = HttpUtil.doRequest(request, false, protocolVersion);
        System.out.println(">>>>>>>>>>>>> doRequest (request + protocol)");
        int responseCode = request.getResponseCode();
        String method = request.getMethod();
        if (!usedOverrideMethod && responseCode == 400 && (method.equals("DELETE") || method.equals("PUT"))) {
            System.out.println(">>>>>>>>>>>>> calling doRequest (request + true + protocol)");
            HttpUtil.doRequest(request, true, protocolVersion);
        }
    }

    public static void doRequest(HttpRequest request) throws IOException {
        System.out.println(">>>>>>>>>>>>> doRequest (request)");
        HttpUtil.doRequest(request, 1);
    }
}

